// Generated by delombok at Tue Jun 25 12:09:00 UTC 2024
package de.qytera.qtaf.xray.dto.jira;

import com.google.gson.JsonObject;

/**
 * The DTO when working with Jira users.
 *
 * @param <R> the application role type
 * @param <G> the group type
 * @see <a href="https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-issues/#api-rest-api-3-issue-issueidorkey-assignee-put">Assign issue (Jira Cloud)</a>
 * @see <a href="https://docs.atlassian.com/software/jira/docs/api/REST/9.8.0/#api/2/issue-assign">Assign issue (Jira Server)</a>
 */
public abstract class UserDto<R extends ApplicationRoleDto, G extends GroupDto> {
    /**
     * Whether the user is active.
     */
    private Boolean active;
    /**
     * The application roles the user is assigned to.
     */
    private SimpleListWrapperDto<R> applicationRoles;
    /**
     * The avatars of the user.
     */
    private JsonObject avatarUrls;
    /**
     * The display name of the user. Depending on the user’s privacy setting, this may return an alternative value.
     */
    private String displayName;
    /**
     * The email address of the user. Depending on the user’s privacy setting, this may be returned as null.
     */
    private String emailAddress;
    /**
     * Expand options that include additional user details in the response.
     */
    private String expand;
    /**
     * The groups that the user belongs to.
     */
    private SimpleListWrapperDto<G> groups;
    /**
     * The locale of the user. Depending on the user’s privacy setting, this may be returned as null.
     */
    private String locale;
    /**
     * The URL of the user.
     */
    private String self;
    /**
     * The time zone specified in the user's profile. Depending on the user’s privacy setting, this may be returned as null.
     */
    private String timeZone;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public UserDto() {
    }

    /**
     * Whether the user is active.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getActive() {
        return this.active;
    }

    /**
     * The application roles the user is assigned to.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SimpleListWrapperDto<R> getApplicationRoles() {
        return this.applicationRoles;
    }

    /**
     * The avatars of the user.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public JsonObject getAvatarUrls() {
        return this.avatarUrls;
    }

    /**
     * The display name of the user. Depending on the user’s privacy setting, this may return an alternative value.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDisplayName() {
        return this.displayName;
    }

    /**
     * The email address of the user. Depending on the user’s privacy setting, this may be returned as null.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getEmailAddress() {
        return this.emailAddress;
    }

    /**
     * Expand options that include additional user details in the response.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getExpand() {
        return this.expand;
    }

    /**
     * The groups that the user belongs to.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SimpleListWrapperDto<G> getGroups() {
        return this.groups;
    }

    /**
     * The locale of the user. Depending on the user’s privacy setting, this may be returned as null.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLocale() {
        return this.locale;
    }

    /**
     * The URL of the user.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSelf() {
        return this.self;
    }

    /**
     * The time zone specified in the user's profile. Depending on the user’s privacy setting, this may be returned as null.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTimeZone() {
        return this.timeZone;
    }

    /**
     * Whether the user is active.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setActive(final Boolean active) {
        this.active = active;
    }

    /**
     * The application roles the user is assigned to.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setApplicationRoles(final SimpleListWrapperDto<R> applicationRoles) {
        this.applicationRoles = applicationRoles;
    }

    /**
     * The avatars of the user.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAvatarUrls(final JsonObject avatarUrls) {
        this.avatarUrls = avatarUrls;
    }

    /**
     * The display name of the user. Depending on the user’s privacy setting, this may return an alternative value.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDisplayName(final String displayName) {
        this.displayName = displayName;
    }

    /**
     * The email address of the user. Depending on the user’s privacy setting, this may be returned as null.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setEmailAddress(final String emailAddress) {
        this.emailAddress = emailAddress;
    }

    /**
     * Expand options that include additional user details in the response.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setExpand(final String expand) {
        this.expand = expand;
    }

    /**
     * The groups that the user belongs to.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setGroups(final SimpleListWrapperDto<G> groups) {
        this.groups = groups;
    }

    /**
     * The locale of the user. Depending on the user’s privacy setting, this may be returned as null.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setLocale(final String locale) {
        this.locale = locale;
    }

    /**
     * The URL of the user.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSelf(final String self) {
        this.self = self;
    }

    /**
     * The time zone specified in the user's profile. Depending on the user’s privacy setting, this may be returned as null.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTimeZone(final String timeZone) {
        this.timeZone = timeZone;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof UserDto)) return false;
        final UserDto<?, ?> other = (UserDto<?, ?>) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$active = this.getActive();
        final java.lang.Object other$active = other.getActive();
        if (this$active == null ? other$active != null : !this$active.equals(other$active)) return false;
        final java.lang.Object this$applicationRoles = this.getApplicationRoles();
        final java.lang.Object other$applicationRoles = other.getApplicationRoles();
        if (this$applicationRoles == null ? other$applicationRoles != null : !this$applicationRoles.equals(other$applicationRoles)) return false;
        final java.lang.Object this$avatarUrls = this.getAvatarUrls();
        final java.lang.Object other$avatarUrls = other.getAvatarUrls();
        if (this$avatarUrls == null ? other$avatarUrls != null : !this$avatarUrls.equals(other$avatarUrls)) return false;
        final java.lang.Object this$displayName = this.getDisplayName();
        final java.lang.Object other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) return false;
        final java.lang.Object this$emailAddress = this.getEmailAddress();
        final java.lang.Object other$emailAddress = other.getEmailAddress();
        if (this$emailAddress == null ? other$emailAddress != null : !this$emailAddress.equals(other$emailAddress)) return false;
        final java.lang.Object this$expand = this.getExpand();
        final java.lang.Object other$expand = other.getExpand();
        if (this$expand == null ? other$expand != null : !this$expand.equals(other$expand)) return false;
        final java.lang.Object this$groups = this.getGroups();
        final java.lang.Object other$groups = other.getGroups();
        if (this$groups == null ? other$groups != null : !this$groups.equals(other$groups)) return false;
        final java.lang.Object this$locale = this.getLocale();
        final java.lang.Object other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) return false;
        final java.lang.Object this$self = this.getSelf();
        final java.lang.Object other$self = other.getSelf();
        if (this$self == null ? other$self != null : !this$self.equals(other$self)) return false;
        final java.lang.Object this$timeZone = this.getTimeZone();
        final java.lang.Object other$timeZone = other.getTimeZone();
        if (this$timeZone == null ? other$timeZone != null : !this$timeZone.equals(other$timeZone)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof UserDto;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $active = this.getActive();
        result = result * PRIME + ($active == null ? 43 : $active.hashCode());
        final java.lang.Object $applicationRoles = this.getApplicationRoles();
        result = result * PRIME + ($applicationRoles == null ? 43 : $applicationRoles.hashCode());
        final java.lang.Object $avatarUrls = this.getAvatarUrls();
        result = result * PRIME + ($avatarUrls == null ? 43 : $avatarUrls.hashCode());
        final java.lang.Object $displayName = this.getDisplayName();
        result = result * PRIME + ($displayName == null ? 43 : $displayName.hashCode());
        final java.lang.Object $emailAddress = this.getEmailAddress();
        result = result * PRIME + ($emailAddress == null ? 43 : $emailAddress.hashCode());
        final java.lang.Object $expand = this.getExpand();
        result = result * PRIME + ($expand == null ? 43 : $expand.hashCode());
        final java.lang.Object $groups = this.getGroups();
        result = result * PRIME + ($groups == null ? 43 : $groups.hashCode());
        final java.lang.Object $locale = this.getLocale();
        result = result * PRIME + ($locale == null ? 43 : $locale.hashCode());
        final java.lang.Object $self = this.getSelf();
        result = result * PRIME + ($self == null ? 43 : $self.hashCode());
        final java.lang.Object $timeZone = this.getTimeZone();
        result = result * PRIME + ($timeZone == null ? 43 : $timeZone.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "UserDto(active=" + this.getActive() + ", applicationRoles=" + this.getApplicationRoles() + ", avatarUrls=" + this.getAvatarUrls() + ", displayName=" + this.getDisplayName() + ", emailAddress=" + this.getEmailAddress() + ", expand=" + this.getExpand() + ", groups=" + this.getGroups() + ", locale=" + this.getLocale() + ", self=" + this.getSelf() + ", timeZone=" + this.getTimeZone() + ")";
    }
}
