/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.xray.config;

import de.qytera.qtaf.core.log.model.collection.TestScenarioLogCollection;
import de.qytera.qtaf.core.log.model.message.LogMessage;
import de.qytera.qtaf.core.log.model.message.StepInformationLogMessage;
import de.qytera.qtaf.xray.config.XrayConfigHelper;
import java.util.Collection;

public class XrayStatusHelper {
    private XrayStatusHelper() {
    }

    public static TestScenarioLogCollection.Status combinedScenarioStatus(Collection<TestScenarioLogCollection> scenarioLogs) {
        if (scenarioLogs.isEmpty()) {
            throw new IllegalArgumentException("Must provide at least one scenario log to determine status");
        }
        boolean anySkipped = false;
        boolean anyPending = false;
        block6: for (TestScenarioLogCollection scenarioLog : scenarioLogs) {
            switch (scenarioLog.getStatus()) {
                case FAILURE: {
                    return TestScenarioLogCollection.Status.FAILURE;
                }
                case PENDING: {
                    anyPending = true;
                    continue block6;
                }
                case SKIPPED: {
                    anySkipped = true;
                    continue block6;
                }
                case SUCCESS: {
                    continue block6;
                }
            }
            throw new IllegalArgumentException(String.format("Unknown status %s", scenarioLog.getStatus()));
        }
        if (anyPending) {
            return TestScenarioLogCollection.Status.PENDING;
        }
        if (anySkipped) {
            return TestScenarioLogCollection.Status.SKIPPED;
        }
        return TestScenarioLogCollection.Status.SUCCESS;
    }

    public static LogMessage.Status combinedStepStatus(Collection<StepInformationLogMessage> stepLogs) {
        if (stepLogs.isEmpty()) {
            throw new IllegalArgumentException("Must provide at least one step log to determine status");
        }
        boolean anySkipped = false;
        boolean anyPending = false;
        block6: for (StepInformationLogMessage stepLog : stepLogs) {
            switch (stepLog.getStatus()) {
                case FAILED: {
                    return LogMessage.Status.FAILED;
                }
                case PENDING: {
                    anyPending = true;
                    continue block6;
                }
                case SKIPPED: {
                    anySkipped = true;
                    continue block6;
                }
                case PASSED: {
                    continue block6;
                }
            }
            throw new IllegalArgumentException(String.format("Unknown status %s", stepLog.getStatus()));
        }
        if (anyPending) {
            return LogMessage.Status.PENDING;
        }
        if (anySkipped) {
            return LogMessage.Status.SKIPPED;
        }
        return LogMessage.Status.PASSED;
    }

    public static String statusToText(TestScenarioLogCollection.Status status) {
        switch (status) {
            case SUCCESS: {
                return XrayStatusHelper.getTestStatusPassed();
            }
            case FAILURE: {
                return XrayStatusHelper.getTestStatusFailed();
            }
            case PENDING: {
                return XrayStatusHelper.getTestStatusPending();
            }
            case SKIPPED: {
                return XrayStatusHelper.getTestStatusSkipped();
            }
        }
        throw new IllegalArgumentException(String.format("Unknown text for status %s", status));
    }

    private static String getTestStatusPassed() {
        String status = XrayConfigHelper.getTestStatusPassed();
        if (status != null) {
            return status;
        }
        return XrayConfigHelper.isXrayCloudService() ? "PASSED" : "PASS";
    }

    private static String getTestStatusFailed() {
        String status = XrayConfigHelper.getTestStatusFailed();
        if (status != null) {
            return status;
        }
        return XrayConfigHelper.isXrayCloudService() ? "FAILED" : "FAIL";
    }

    private static String getTestStatusPending() {
        String status = XrayConfigHelper.getTestStatusPending();
        if (status != null) {
            return status;
        }
        return "EXECUTING";
    }

    private static String getTestStatusSkipped() {
        String status = XrayConfigHelper.getTestStatusSkipped();
        if (status != null) {
            return status;
        }
        return "TODO";
    }

    public static String statusToText(LogMessage.Status status) {
        switch (status) {
            case PASSED: {
                return XrayStatusHelper.getStepStatusPassed();
            }
            case FAILED: {
                return XrayStatusHelper.getStepStatusFailed();
            }
            case PENDING: {
                return XrayStatusHelper.getStepStatusPending();
            }
            case SKIPPED: {
                return XrayStatusHelper.getStepStatusSkipped();
            }
        }
        throw new IllegalArgumentException(String.format("Unknown text for status %s", status));
    }

    private static String getStepStatusPassed() {
        String status = XrayConfigHelper.getStepStatusPassed();
        if (status != null) {
            return status;
        }
        return XrayConfigHelper.isXrayCloudService() ? "PASSED" : "PASS";
    }

    private static String getStepStatusFailed() {
        String status = XrayConfigHelper.getStepStatusFailed();
        if (status != null) {
            return status;
        }
        return XrayConfigHelper.isXrayCloudService() ? "FAILED" : "FAIL";
    }

    private static String getStepStatusPending() {
        String status = XrayConfigHelper.getStepStatusPending();
        return status != null ? status : "EXECUTING";
    }

    private static String getStepStatusSkipped() {
        String status = XrayConfigHelper.getStepStatusSkipped();
        return status != null ? status : "TODO";
    }

    private static String getStepStatusUndefined() {
        String status = XrayConfigHelper.getStepStatusUndefined();
        return status != null ? status : "TODO";
    }
}

