/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.xray.event_subscriber;

import de.qytera.qtaf.core.events.EventListenerInitializer;
import de.qytera.qtaf.core.events.QtafEvents;
import de.qytera.qtaf.core.events.interfaces.IEventSubscriber;
import de.qytera.qtaf.testng.event_subscriber.TestNGLoggingSubscriber;
import de.qytera.qtaf.xray.annotation.XrayTest;
import de.qytera.qtaf.xray.config.XrayConfigHelper;
import java.lang.reflect.Method;
import java.util.Optional;
import org.testng.internal.ConstructorOrMethod;
import rx.Subscription;

public class InitializationSubscriber
implements IEventSubscriber {
    private Subscription eventInitializationSubscription;

    public void initialize() {
        if (this.eventInitializationSubscription != null) {
            return;
        }
        this.eventInitializationSubscription = QtafEvents.eventListenersInitialized.subscribe(ignored -> this.onEventListenersInitialized());
    }

    private void onEventListenersInitialized() {
        if (!XrayConfigHelper.isEnabled()) {
            return;
        }
        for (IEventSubscriber eventSubscriber : EventListenerInitializer.getEventSubscribers()) {
            if (!(eventSubscriber instanceof TestNGLoggingSubscriber)) continue;
            TestNGLoggingSubscriber subscriber = (TestNGLoggingSubscriber)eventSubscriber;
            subscriber.addLogMessageEnhancer(testResult -> {
                Method method;
                XrayTest xrayAnnotation;
                ConstructorOrMethod constructorOrMethod = testResult.getMethod().getConstructorOrMethod();
                if (constructorOrMethod.getMethod() != null && (xrayAnnotation = (method = constructorOrMethod.getMethod()).getAnnotation(XrayTest.class)) != null) {
                    return Optional.of(xrayAnnotation.key());
                }
                return Optional.empty();
            });
        }
    }
}

