/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.xray.repository.xray;

import com.google.gson.JsonElement;
import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.config.exception.MissingConfigurationValueException;
import de.qytera.qtaf.core.gson.GsonFactory;
import de.qytera.qtaf.core.log.model.error.ErrorLog;
import de.qytera.qtaf.core.log.model.error.ErrorLogCollection;
import de.qytera.qtaf.http.RequestBuilder;
import de.qytera.qtaf.http.WebService;
import de.qytera.qtaf.xray.config.XrayConfigHelper;
import de.qytera.qtaf.xray.events.XrayEvents;
import de.qytera.qtaf.xray.log.XrayAuthenticationErrorLog;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import lombok.Generated;

public class XrayCloudAuthenticator {
    private static String jwtToken;

    public static String getXrayAuthorizationHeaderValue() throws MissingConfigurationValueException {
        if (jwtToken == null) {
            try {
                RequestBuilder request = WebService.buildRequest((URI)new URI("https://xray.cloud.getxray.app/api/v2/authenticate"));
                try (Response response = WebService.post((RequestBuilder)request, (Entity)Entity.json((Object)XrayCloudAuthenticator.getAuthenticationBody()));){
                    String responseData = (String)response.readEntity(String.class);
                    XrayEvents.authenticationResponseAvailable.onNext((Object)response);
                    if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                        XrayEvents.authenticationSuccess.onNext((Object)false);
                        XrayAuthenticationErrorLog authErrorLog = new XrayAuthenticationErrorLog(new Exception(responseData)).setErrorMessage(response.getStatusInfo().getReasonPhrase()).setStatusCode(response.getStatus());
                        ErrorLogCollection.getInstance().addErrorLog((ErrorLog)authErrorLog);
                    } else {
                        XrayEvents.authenticationSuccess.onNext((Object)true);
                        jwtToken = responseData.replaceAll("(^\")|(\"$)", "");
                    }
                }
            }
            catch (URISyntaxException exception) {
                XrayEvents.authenticationSuccess.onNext((Object)false);
                ErrorLog authErrorLog = new ErrorLog((Throwable)exception);
                ErrorLogCollection.getInstance().addErrorLog(authErrorLog);
            }
        }
        return String.format("Bearer %s", jwtToken);
    }

    private static JsonElement getAuthenticationBody() throws MissingConfigurationValueException {
        String clientId = XrayConfigHelper.getAuthenticationXrayClientId();
        if (clientId == null) {
            throw new MissingConfigurationValueException("xray.authentication.xray.clientId", QtafFactory.getConfiguration());
        }
        String clientSecret = XrayConfigHelper.getAuthenticationXrayClientSecret();
        if (clientSecret == null) {
            throw new MissingConfigurationValueException("xray.authentication.xray.clientSecret", QtafFactory.getConfiguration());
        }
        Map<String, String> body = Map.of("client_id", clientId, "client_secret", clientSecret);
        return GsonFactory.getInstance().toJsonTree(body);
    }

    @Generated
    private XrayCloudAuthenticator() {
    }
}

