// Generated by delombok at Mon Sep 04 07:26:06 UTC 2023
package de.qytera.qtaf.xray.dto.jira;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;

/**
 * The DTO describing Jira cloud project details.
 *
 * @see <a href="https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-projects/#api-rest-api-3-project-projectidorkey-get">Get project (Jira Cloud)</a>
 */
public class ProjectCloudDto extends ProjectDto<UserCloudDto, IssueTypeCloudDto, VersionCloudDto> {
    /**
     * The user who archived the project.
     */
    private UserCloudDto archivedBy;
    /**
     * The date when the project was archived.
     */
    private String archivedDate;
    /**
     * Whether the project is marked as deleted.
     */
    private Boolean deleted;
    /**
     * The user who marked the project as deleted.
     */
    private UserCloudDto deletedBy;
    /**
     * The date when the project was marked as deleted.
     */
    private String deletedDate;
    /**
     * Whether the project is selected as a favorite.
     */
    private Boolean favourite;
    /**
     * Insights about the project.
     */
    private ProjectInsight insight;
    /**
     * Whether the project is private.
     */
    private Boolean isPrivate;
    /**
     * The issue type hierarchy for the project.
     */
    private Hierarchy issueTypeHierarchy;
    /**
     * The project landing page info.
     */
    private LandingPageInfo landingPageInfo;
    /**
     * User permissions on the project
     */
    private ProjectPermissions permissions;
    /**
     * Map of project properties.
     */
    private JsonObject properties;
    /**
     * The date when the project is deleted permanently.
     */
    private String retentionTillDate;
    /**
     * Whether the project is simplified.
     */
    private Boolean simplified;
    /**
     * The type of the project.
     */
    private String style;
    /**
     * Unique ID for next-gen projects.
     */
    private String uuid;


    /**
     * Insights about a project.
     */
    public static class ProjectInsight {
        /**
         * The last issue update time.
         */
        private String lastIssueUpdateTime;
        /**
         * Total issue count.
         */
        private Integer totalIssueCount;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ProjectInsight() {
        }

        /**
         * The last issue update time.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getLastIssueUpdateTime() {
            return this.lastIssueUpdateTime;
        }

        /**
         * Total issue count.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Integer getTotalIssueCount() {
            return this.totalIssueCount;
        }

        /**
         * The last issue update time.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setLastIssueUpdateTime(final String lastIssueUpdateTime) {
            this.lastIssueUpdateTime = lastIssueUpdateTime;
        }

        /**
         * Total issue count.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setTotalIssueCount(final Integer totalIssueCount) {
            this.totalIssueCount = totalIssueCount;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof ProjectCloudDto.ProjectInsight)) return false;
            final ProjectCloudDto.ProjectInsight other = (ProjectCloudDto.ProjectInsight) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$totalIssueCount = this.getTotalIssueCount();
            final java.lang.Object other$totalIssueCount = other.getTotalIssueCount();
            if (this$totalIssueCount == null ? other$totalIssueCount != null : !this$totalIssueCount.equals(other$totalIssueCount)) return false;
            final java.lang.Object this$lastIssueUpdateTime = this.getLastIssueUpdateTime();
            final java.lang.Object other$lastIssueUpdateTime = other.getLastIssueUpdateTime();
            if (this$lastIssueUpdateTime == null ? other$lastIssueUpdateTime != null : !this$lastIssueUpdateTime.equals(other$lastIssueUpdateTime)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof ProjectCloudDto.ProjectInsight;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $totalIssueCount = this.getTotalIssueCount();
            result = result * PRIME + ($totalIssueCount == null ? 43 : $totalIssueCount.hashCode());
            final java.lang.Object $lastIssueUpdateTime = this.getLastIssueUpdateTime();
            result = result * PRIME + ($lastIssueUpdateTime == null ? 43 : $lastIssueUpdateTime.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "ProjectCloudDto.ProjectInsight(lastIssueUpdateTime=" + this.getLastIssueUpdateTime() + ", totalIssueCount=" + this.getTotalIssueCount() + ")";
        }
    }


    /**
     * The issue type hierarchy for a project.
     */
    public static class Hierarchy {
        /**
         * Details about the hierarchy level.
         */
        private List<SimplifiedHierarchyLevel> levels = new ArrayList<>();


        public static class SimplifiedHierarchyLevel {
            /**
             * The hierarchy level's number.
             */
            private Integer hierarchyLevelNumber;
            /**
             * The issue types available in this hierarchy level.
             */
            private List<Integer> issueTypeIds = new ArrayList<>();
            /**
             * The level of this item in the hierarchy.
             */
            private Integer level;
            /**
             * The name of this hierarchy level.
             */
            private String name;

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public SimplifiedHierarchyLevel() {
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public Integer getHierarchyLevelNumber() {
                return this.hierarchyLevelNumber;
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public List<Integer> getIssueTypeIds() {
                return this.issueTypeIds;
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public Integer getLevel() {
                return this.level;
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public String getName() {
                return this.name;
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public void setHierarchyLevelNumber(final Integer hierarchyLevelNumber) {
                this.hierarchyLevelNumber = hierarchyLevelNumber;
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public void setIssueTypeIds(final List<Integer> issueTypeIds) {
                this.issueTypeIds = issueTypeIds;
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public void setLevel(final Integer level) {
                this.level = level;
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public void setName(final String name) {
                this.name = name;
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public boolean equals(final java.lang.Object o) {
                if (o == this) return true;
                if (!(o instanceof ProjectCloudDto.Hierarchy.SimplifiedHierarchyLevel)) return false;
                final ProjectCloudDto.Hierarchy.SimplifiedHierarchyLevel other = (ProjectCloudDto.Hierarchy.SimplifiedHierarchyLevel) o;
                if (!other.canEqual((java.lang.Object) this)) return false;
                final java.lang.Object this$hierarchyLevelNumber = this.getHierarchyLevelNumber();
                final java.lang.Object other$hierarchyLevelNumber = other.getHierarchyLevelNumber();
                if (this$hierarchyLevelNumber == null ? other$hierarchyLevelNumber != null : !this$hierarchyLevelNumber.equals(other$hierarchyLevelNumber)) return false;
                final java.lang.Object this$level = this.getLevel();
                final java.lang.Object other$level = other.getLevel();
                if (this$level == null ? other$level != null : !this$level.equals(other$level)) return false;
                final java.lang.Object this$issueTypeIds = this.getIssueTypeIds();
                final java.lang.Object other$issueTypeIds = other.getIssueTypeIds();
                if (this$issueTypeIds == null ? other$issueTypeIds != null : !this$issueTypeIds.equals(other$issueTypeIds)) return false;
                final java.lang.Object this$name = this.getName();
                final java.lang.Object other$name = other.getName();
                if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
                return true;
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected boolean canEqual(final java.lang.Object other) {
                return other instanceof ProjectCloudDto.Hierarchy.SimplifiedHierarchyLevel;
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public int hashCode() {
                final int PRIME = 59;
                int result = 1;
                final java.lang.Object $hierarchyLevelNumber = this.getHierarchyLevelNumber();
                result = result * PRIME + ($hierarchyLevelNumber == null ? 43 : $hierarchyLevelNumber.hashCode());
                final java.lang.Object $level = this.getLevel();
                result = result * PRIME + ($level == null ? 43 : $level.hashCode());
                final java.lang.Object $issueTypeIds = this.getIssueTypeIds();
                result = result * PRIME + ($issueTypeIds == null ? 43 : $issueTypeIds.hashCode());
                final java.lang.Object $name = this.getName();
                result = result * PRIME + ($name == null ? 43 : $name.hashCode());
                return result;
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public java.lang.String toString() {
                return "ProjectCloudDto.Hierarchy.SimplifiedHierarchyLevel(hierarchyLevelNumber=" + this.getHierarchyLevelNumber() + ", issueTypeIds=" + this.getIssueTypeIds() + ", level=" + this.getLevel() + ", name=" + this.getName() + ")";
            }
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Hierarchy() {
        }

        /**
         * Details about the hierarchy level.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public List<SimplifiedHierarchyLevel> getLevels() {
            return this.levels;
        }

        /**
         * Details about the hierarchy level.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setLevels(final List<SimplifiedHierarchyLevel> levels) {
            this.levels = levels;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof ProjectCloudDto.Hierarchy)) return false;
            final ProjectCloudDto.Hierarchy other = (ProjectCloudDto.Hierarchy) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$levels = this.getLevels();
            final java.lang.Object other$levels = other.getLevels();
            if (this$levels == null ? other$levels != null : !this$levels.equals(other$levels)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof ProjectCloudDto.Hierarchy;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $levels = this.getLevels();
            result = result * PRIME + ($levels == null ? 43 : $levels.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "ProjectCloudDto.Hierarchy(levels=" + this.getLevels() + ")";
        }
    }


    /**
     * A project's landing page info.
     */
    public static class LandingPageInfo {
        /**
         * Landing page attributes.
         */
        private JsonObject attributes;
        /**
         * Landing page board ID.
         */
        private Integer boardId;
        /**
         * Landing page board name.
         */
        private String boardName;
        /**
         * Landing page project key.
         */
        private String projectKey;
        /**
         * Landing page project type
         */
        private String projectType;
        /**
         * Landing page queue category.
         */
        private String queueCategory;
        /**
         * Landing page queue ID.
         */
        private Integer queueId;
        /**
         * Whether the project is a simple board.
         */
        private Boolean simpleBoard;
        /**
         * Whether the project has been simplified.
         */
        private Boolean simplified;
        /**
         * Landing page URL.
         */
        private String url;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public LandingPageInfo() {
        }

        /**
         * Landing page attributes.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public JsonObject getAttributes() {
            return this.attributes;
        }

        /**
         * Landing page board ID.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Integer getBoardId() {
            return this.boardId;
        }

        /**
         * Landing page board name.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getBoardName() {
            return this.boardName;
        }

        /**
         * Landing page project key.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getProjectKey() {
            return this.projectKey;
        }

        /**
         * Landing page project type
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getProjectType() {
            return this.projectType;
        }

        /**
         * Landing page queue category.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getQueueCategory() {
            return this.queueCategory;
        }

        /**
         * Landing page queue ID.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Integer getQueueId() {
            return this.queueId;
        }

        /**
         * Whether the project is a simple board.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Boolean getSimpleBoard() {
            return this.simpleBoard;
        }

        /**
         * Whether the project has been simplified.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Boolean getSimplified() {
            return this.simplified;
        }

        /**
         * Landing page URL.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getUrl() {
            return this.url;
        }

        /**
         * Landing page attributes.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setAttributes(final JsonObject attributes) {
            this.attributes = attributes;
        }

        /**
         * Landing page board ID.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setBoardId(final Integer boardId) {
            this.boardId = boardId;
        }

        /**
         * Landing page board name.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setBoardName(final String boardName) {
            this.boardName = boardName;
        }

        /**
         * Landing page project key.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setProjectKey(final String projectKey) {
            this.projectKey = projectKey;
        }

        /**
         * Landing page project type
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setProjectType(final String projectType) {
            this.projectType = projectType;
        }

        /**
         * Landing page queue category.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setQueueCategory(final String queueCategory) {
            this.queueCategory = queueCategory;
        }

        /**
         * Landing page queue ID.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setQueueId(final Integer queueId) {
            this.queueId = queueId;
        }

        /**
         * Whether the project is a simple board.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setSimpleBoard(final Boolean simpleBoard) {
            this.simpleBoard = simpleBoard;
        }

        /**
         * Whether the project has been simplified.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setSimplified(final Boolean simplified) {
            this.simplified = simplified;
        }

        /**
         * Landing page URL.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setUrl(final String url) {
            this.url = url;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof ProjectCloudDto.LandingPageInfo)) return false;
            final ProjectCloudDto.LandingPageInfo other = (ProjectCloudDto.LandingPageInfo) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$boardId = this.getBoardId();
            final java.lang.Object other$boardId = other.getBoardId();
            if (this$boardId == null ? other$boardId != null : !this$boardId.equals(other$boardId)) return false;
            final java.lang.Object this$queueId = this.getQueueId();
            final java.lang.Object other$queueId = other.getQueueId();
            if (this$queueId == null ? other$queueId != null : !this$queueId.equals(other$queueId)) return false;
            final java.lang.Object this$simpleBoard = this.getSimpleBoard();
            final java.lang.Object other$simpleBoard = other.getSimpleBoard();
            if (this$simpleBoard == null ? other$simpleBoard != null : !this$simpleBoard.equals(other$simpleBoard)) return false;
            final java.lang.Object this$simplified = this.getSimplified();
            final java.lang.Object other$simplified = other.getSimplified();
            if (this$simplified == null ? other$simplified != null : !this$simplified.equals(other$simplified)) return false;
            final java.lang.Object this$attributes = this.getAttributes();
            final java.lang.Object other$attributes = other.getAttributes();
            if (this$attributes == null ? other$attributes != null : !this$attributes.equals(other$attributes)) return false;
            final java.lang.Object this$boardName = this.getBoardName();
            final java.lang.Object other$boardName = other.getBoardName();
            if (this$boardName == null ? other$boardName != null : !this$boardName.equals(other$boardName)) return false;
            final java.lang.Object this$projectKey = this.getProjectKey();
            final java.lang.Object other$projectKey = other.getProjectKey();
            if (this$projectKey == null ? other$projectKey != null : !this$projectKey.equals(other$projectKey)) return false;
            final java.lang.Object this$projectType = this.getProjectType();
            final java.lang.Object other$projectType = other.getProjectType();
            if (this$projectType == null ? other$projectType != null : !this$projectType.equals(other$projectType)) return false;
            final java.lang.Object this$queueCategory = this.getQueueCategory();
            final java.lang.Object other$queueCategory = other.getQueueCategory();
            if (this$queueCategory == null ? other$queueCategory != null : !this$queueCategory.equals(other$queueCategory)) return false;
            final java.lang.Object this$url = this.getUrl();
            final java.lang.Object other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof ProjectCloudDto.LandingPageInfo;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $boardId = this.getBoardId();
            result = result * PRIME + ($boardId == null ? 43 : $boardId.hashCode());
            final java.lang.Object $queueId = this.getQueueId();
            result = result * PRIME + ($queueId == null ? 43 : $queueId.hashCode());
            final java.lang.Object $simpleBoard = this.getSimpleBoard();
            result = result * PRIME + ($simpleBoard == null ? 43 : $simpleBoard.hashCode());
            final java.lang.Object $simplified = this.getSimplified();
            result = result * PRIME + ($simplified == null ? 43 : $simplified.hashCode());
            final java.lang.Object $attributes = this.getAttributes();
            result = result * PRIME + ($attributes == null ? 43 : $attributes.hashCode());
            final java.lang.Object $boardName = this.getBoardName();
            result = result * PRIME + ($boardName == null ? 43 : $boardName.hashCode());
            final java.lang.Object $projectKey = this.getProjectKey();
            result = result * PRIME + ($projectKey == null ? 43 : $projectKey.hashCode());
            final java.lang.Object $projectType = this.getProjectType();
            result = result * PRIME + ($projectType == null ? 43 : $projectType.hashCode());
            final java.lang.Object $queueCategory = this.getQueueCategory();
            result = result * PRIME + ($queueCategory == null ? 43 : $queueCategory.hashCode());
            final java.lang.Object $url = this.getUrl();
            result = result * PRIME + ($url == null ? 43 : $url.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "ProjectCloudDto.LandingPageInfo(attributes=" + this.getAttributes() + ", boardId=" + this.getBoardId() + ", boardName=" + this.getBoardName() + ", projectKey=" + this.getProjectKey() + ", projectType=" + this.getProjectType() + ", queueCategory=" + this.getQueueCategory() + ", queueId=" + this.getQueueId() + ", simpleBoard=" + this.getSimpleBoard() + ", simplified=" + this.getSimplified() + ", url=" + this.getUrl() + ")";
        }
    }


    /**
     * User permissions on a project.
     */
    public static class ProjectPermissions {
        /**
         * Whether the logged user can edit the project.
         */
        private Boolean canEdit;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ProjectPermissions() {
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Boolean getCanEdit() {
            return this.canEdit;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setCanEdit(final Boolean canEdit) {
            this.canEdit = canEdit;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof ProjectCloudDto.ProjectPermissions)) return false;
            final ProjectCloudDto.ProjectPermissions other = (ProjectCloudDto.ProjectPermissions) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$canEdit = this.getCanEdit();
            final java.lang.Object other$canEdit = other.getCanEdit();
            if (this$canEdit == null ? other$canEdit != null : !this$canEdit.equals(other$canEdit)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof ProjectCloudDto.ProjectPermissions;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $canEdit = this.getCanEdit();
            result = result * PRIME + ($canEdit == null ? 43 : $canEdit.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "ProjectCloudDto.ProjectPermissions(canEdit=" + this.getCanEdit() + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ProjectCloudDto() {
    }

    /**
     * The user who archived the project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public UserCloudDto getArchivedBy() {
        return this.archivedBy;
    }

    /**
     * The date when the project was archived.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getArchivedDate() {
        return this.archivedDate;
    }

    /**
     * Whether the project is marked as deleted.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getDeleted() {
        return this.deleted;
    }

    /**
     * The user who marked the project as deleted.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public UserCloudDto getDeletedBy() {
        return this.deletedBy;
    }

    /**
     * The date when the project was marked as deleted.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDeletedDate() {
        return this.deletedDate;
    }

    /**
     * Whether the project is selected as a favorite.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getFavourite() {
        return this.favourite;
    }

    /**
     * Insights about the project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ProjectInsight getInsight() {
        return this.insight;
    }

    /**
     * Whether the project is private.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsPrivate() {
        return this.isPrivate;
    }

    /**
     * The issue type hierarchy for the project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Hierarchy getIssueTypeHierarchy() {
        return this.issueTypeHierarchy;
    }

    /**
     * The project landing page info.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public LandingPageInfo getLandingPageInfo() {
        return this.landingPageInfo;
    }

    /**
     * User permissions on the project
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ProjectPermissions getPermissions() {
        return this.permissions;
    }

    /**
     * Map of project properties.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public JsonObject getProperties() {
        return this.properties;
    }

    /**
     * The date when the project is deleted permanently.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRetentionTillDate() {
        return this.retentionTillDate;
    }

    /**
     * Whether the project is simplified.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getSimplified() {
        return this.simplified;
    }

    /**
     * The type of the project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStyle() {
        return this.style;
    }

    /**
     * Unique ID for next-gen projects.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUuid() {
        return this.uuid;
    }

    /**
     * The user who archived the project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setArchivedBy(final UserCloudDto archivedBy) {
        this.archivedBy = archivedBy;
    }

    /**
     * The date when the project was archived.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setArchivedDate(final String archivedDate) {
        this.archivedDate = archivedDate;
    }

    /**
     * Whether the project is marked as deleted.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDeleted(final Boolean deleted) {
        this.deleted = deleted;
    }

    /**
     * The user who marked the project as deleted.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDeletedBy(final UserCloudDto deletedBy) {
        this.deletedBy = deletedBy;
    }

    /**
     * The date when the project was marked as deleted.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDeletedDate(final String deletedDate) {
        this.deletedDate = deletedDate;
    }

    /**
     * Whether the project is selected as a favorite.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFavourite(final Boolean favourite) {
        this.favourite = favourite;
    }

    /**
     * Insights about the project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setInsight(final ProjectInsight insight) {
        this.insight = insight;
    }

    /**
     * Whether the project is private.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setIsPrivate(final Boolean isPrivate) {
        this.isPrivate = isPrivate;
    }

    /**
     * The issue type hierarchy for the project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setIssueTypeHierarchy(final Hierarchy issueTypeHierarchy) {
        this.issueTypeHierarchy = issueTypeHierarchy;
    }

    /**
     * The project landing page info.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setLandingPageInfo(final LandingPageInfo landingPageInfo) {
        this.landingPageInfo = landingPageInfo;
    }

    /**
     * User permissions on the project
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPermissions(final ProjectPermissions permissions) {
        this.permissions = permissions;
    }

    /**
     * Map of project properties.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setProperties(final JsonObject properties) {
        this.properties = properties;
    }

    /**
     * The date when the project is deleted permanently.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRetentionTillDate(final String retentionTillDate) {
        this.retentionTillDate = retentionTillDate;
    }

    /**
     * Whether the project is simplified.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSimplified(final Boolean simplified) {
        this.simplified = simplified;
    }

    /**
     * The type of the project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStyle(final String style) {
        this.style = style;
    }

    /**
     * Unique ID for next-gen projects.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUuid(final String uuid) {
        this.uuid = uuid;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "ProjectCloudDto(archivedBy=" + this.getArchivedBy() + ", archivedDate=" + this.getArchivedDate() + ", deleted=" + this.getDeleted() + ", deletedBy=" + this.getDeletedBy() + ", deletedDate=" + this.getDeletedDate() + ", favourite=" + this.getFavourite() + ", insight=" + this.getInsight() + ", isPrivate=" + this.getIsPrivate() + ", issueTypeHierarchy=" + this.getIssueTypeHierarchy() + ", landingPageInfo=" + this.getLandingPageInfo() + ", permissions=" + this.getPermissions() + ", properties=" + this.getProperties() + ", retentionTillDate=" + this.getRetentionTillDate() + ", simplified=" + this.getSimplified() + ", style=" + this.getStyle() + ", uuid=" + this.getUuid() + ")";
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ProjectCloudDto)) return false;
        final ProjectCloudDto other = (ProjectCloudDto) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$deleted = this.getDeleted();
        final java.lang.Object other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !this$deleted.equals(other$deleted)) return false;
        final java.lang.Object this$favourite = this.getFavourite();
        final java.lang.Object other$favourite = other.getFavourite();
        if (this$favourite == null ? other$favourite != null : !this$favourite.equals(other$favourite)) return false;
        final java.lang.Object this$isPrivate = this.getIsPrivate();
        final java.lang.Object other$isPrivate = other.getIsPrivate();
        if (this$isPrivate == null ? other$isPrivate != null : !this$isPrivate.equals(other$isPrivate)) return false;
        final java.lang.Object this$simplified = this.getSimplified();
        final java.lang.Object other$simplified = other.getSimplified();
        if (this$simplified == null ? other$simplified != null : !this$simplified.equals(other$simplified)) return false;
        final java.lang.Object this$archivedBy = this.getArchivedBy();
        final java.lang.Object other$archivedBy = other.getArchivedBy();
        if (this$archivedBy == null ? other$archivedBy != null : !this$archivedBy.equals(other$archivedBy)) return false;
        final java.lang.Object this$archivedDate = this.getArchivedDate();
        final java.lang.Object other$archivedDate = other.getArchivedDate();
        if (this$archivedDate == null ? other$archivedDate != null : !this$archivedDate.equals(other$archivedDate)) return false;
        final java.lang.Object this$deletedBy = this.getDeletedBy();
        final java.lang.Object other$deletedBy = other.getDeletedBy();
        if (this$deletedBy == null ? other$deletedBy != null : !this$deletedBy.equals(other$deletedBy)) return false;
        final java.lang.Object this$deletedDate = this.getDeletedDate();
        final java.lang.Object other$deletedDate = other.getDeletedDate();
        if (this$deletedDate == null ? other$deletedDate != null : !this$deletedDate.equals(other$deletedDate)) return false;
        final java.lang.Object this$insight = this.getInsight();
        final java.lang.Object other$insight = other.getInsight();
        if (this$insight == null ? other$insight != null : !this$insight.equals(other$insight)) return false;
        final java.lang.Object this$issueTypeHierarchy = this.getIssueTypeHierarchy();
        final java.lang.Object other$issueTypeHierarchy = other.getIssueTypeHierarchy();
        if (this$issueTypeHierarchy == null ? other$issueTypeHierarchy != null : !this$issueTypeHierarchy.equals(other$issueTypeHierarchy)) return false;
        final java.lang.Object this$landingPageInfo = this.getLandingPageInfo();
        final java.lang.Object other$landingPageInfo = other.getLandingPageInfo();
        if (this$landingPageInfo == null ? other$landingPageInfo != null : !this$landingPageInfo.equals(other$landingPageInfo)) return false;
        final java.lang.Object this$permissions = this.getPermissions();
        final java.lang.Object other$permissions = other.getPermissions();
        if (this$permissions == null ? other$permissions != null : !this$permissions.equals(other$permissions)) return false;
        final java.lang.Object this$properties = this.getProperties();
        final java.lang.Object other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !this$properties.equals(other$properties)) return false;
        final java.lang.Object this$retentionTillDate = this.getRetentionTillDate();
        final java.lang.Object other$retentionTillDate = other.getRetentionTillDate();
        if (this$retentionTillDate == null ? other$retentionTillDate != null : !this$retentionTillDate.equals(other$retentionTillDate)) return false;
        final java.lang.Object this$style = this.getStyle();
        final java.lang.Object other$style = other.getStyle();
        if (this$style == null ? other$style != null : !this$style.equals(other$style)) return false;
        final java.lang.Object this$uuid = this.getUuid();
        final java.lang.Object other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ProjectCloudDto;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $deleted = this.getDeleted();
        result = result * PRIME + ($deleted == null ? 43 : $deleted.hashCode());
        final java.lang.Object $favourite = this.getFavourite();
        result = result * PRIME + ($favourite == null ? 43 : $favourite.hashCode());
        final java.lang.Object $isPrivate = this.getIsPrivate();
        result = result * PRIME + ($isPrivate == null ? 43 : $isPrivate.hashCode());
        final java.lang.Object $simplified = this.getSimplified();
        result = result * PRIME + ($simplified == null ? 43 : $simplified.hashCode());
        final java.lang.Object $archivedBy = this.getArchivedBy();
        result = result * PRIME + ($archivedBy == null ? 43 : $archivedBy.hashCode());
        final java.lang.Object $archivedDate = this.getArchivedDate();
        result = result * PRIME + ($archivedDate == null ? 43 : $archivedDate.hashCode());
        final java.lang.Object $deletedBy = this.getDeletedBy();
        result = result * PRIME + ($deletedBy == null ? 43 : $deletedBy.hashCode());
        final java.lang.Object $deletedDate = this.getDeletedDate();
        result = result * PRIME + ($deletedDate == null ? 43 : $deletedDate.hashCode());
        final java.lang.Object $insight = this.getInsight();
        result = result * PRIME + ($insight == null ? 43 : $insight.hashCode());
        final java.lang.Object $issueTypeHierarchy = this.getIssueTypeHierarchy();
        result = result * PRIME + ($issueTypeHierarchy == null ? 43 : $issueTypeHierarchy.hashCode());
        final java.lang.Object $landingPageInfo = this.getLandingPageInfo();
        result = result * PRIME + ($landingPageInfo == null ? 43 : $landingPageInfo.hashCode());
        final java.lang.Object $permissions = this.getPermissions();
        result = result * PRIME + ($permissions == null ? 43 : $permissions.hashCode());
        final java.lang.Object $properties = this.getProperties();
        result = result * PRIME + ($properties == null ? 43 : $properties.hashCode());
        final java.lang.Object $retentionTillDate = this.getRetentionTillDate();
        result = result * PRIME + ($retentionTillDate == null ? 43 : $retentionTillDate.hashCode());
        final java.lang.Object $style = this.getStyle();
        result = result * PRIME + ($style == null ? 43 : $style.hashCode());
        final java.lang.Object $uuid = this.getUuid();
        result = result * PRIME + ($uuid == null ? 43 : $uuid.hashCode());
        return result;
    }
}
