/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.xray.entity;

import de.qytera.qtaf.core.log.model.error.ErrorLog;
import de.qytera.qtaf.core.log.model.error.ErrorLogCollection;
import de.qytera.qtaf.core.util.Base64Helper;
import de.qytera.qtaf.xray.error.EvidenceUploadError;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.activation.FileTypeMap;
import lombok.Generated;

public class XrayEvidenceItemEntity {
    private final String data;
    private final String filename;
    private String contentType;

    public static XrayEvidenceItemEntity fromFile(String filepath) {
        return XrayEvidenceItemEntity.fromFile(filepath, null);
    }

    public static XrayEvidenceItemEntity fromFile(String filepath, String evidenceName) {
        try {
            Path path = Paths.get(filepath, new String[0]);
            String mimeType = FileTypeMap.getDefaultFileTypeMap().getContentType(path.toFile());
            return XrayEvidenceItemEntity.builder().filename(evidenceName == null ? path.getFileName().toString() : evidenceName).data(Base64Helper.encodeFileContent((String)path.toAbsolutePath().toString())).contentType(mimeType).build();
        }
        catch (IOException | NullPointerException e) {
            EvidenceUploadError error = new EvidenceUploadError(e).setFilepath(filepath);
            ErrorLogCollection.getInstance().addErrorLog((ErrorLog)error);
            return null;
        }
    }

    public static XrayEvidenceItemEntity fromString(String data, String evidenceName) {
        try {
            String mimeType = FileTypeMap.getDefaultFileTypeMap().getContentType(data);
            return XrayEvidenceItemEntity.builder().filename(evidenceName).data(Base64Helper.encode((String)data)).contentType(mimeType).build();
        }
        catch (NullPointerException e) {
            ErrorLogCollection.getInstance().addErrorLog((ErrorLog)new EvidenceUploadError(e));
            return null;
        }
    }

    @Generated
    XrayEvidenceItemEntity(String data, String filename, String contentType) {
        this.data = data;
        this.filename = filename;
        this.contentType = contentType;
    }

    @Generated
    private static XrayEvidenceItemEntityBuilder builder() {
        return new XrayEvidenceItemEntityBuilder();
    }

    @Generated
    public String getData() {
        return this.data;
    }

    @Generated
    public String getFilename() {
        return this.filename;
    }

    @Generated
    public String getContentType() {
        return this.contentType;
    }

    @Generated
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Generated
    private static class XrayEvidenceItemEntityBuilder {
        @Generated
        private String data;
        @Generated
        private String filename;
        @Generated
        private String contentType;

        @Generated
        XrayEvidenceItemEntityBuilder() {
        }

        @Generated
        private XrayEvidenceItemEntityBuilder data(String data) {
            this.data = data;
            return this;
        }

        @Generated
        private XrayEvidenceItemEntityBuilder filename(String filename) {
            this.filename = filename;
            return this;
        }

        @Generated
        private XrayEvidenceItemEntityBuilder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Generated
        private XrayEvidenceItemEntity build() {
            return new XrayEvidenceItemEntity(this.data, this.filename, this.contentType);
        }

        @Generated
        public String toString() {
            return "XrayEvidenceItemEntity.XrayEvidenceItemEntityBuilder(data=" + this.data + ", filename=" + this.filename + ", contentType=" + this.contentType + ")";
        }
    }
}

