/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.xray.repository.xray;

import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.config.exception.MissingConfigurationValueException;
import de.qytera.qtaf.core.gson.GsonFactory;
import de.qytera.qtaf.http.RequestBuilder;
import de.qytera.qtaf.http.WebService;
import de.qytera.qtaf.xray.dto.response.steps.XrayServerTestStepResponseDto;
import de.qytera.qtaf.xray.dto.response.steps.XrayTestStepResponseDto;
import de.qytera.qtaf.xray.repository.jira.JiraIssueRepository;
import de.qytera.qtaf.xray.repository.xray.XrayTestRepository;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public class XrayTestRepositoryServer
implements XrayTestRepository {
    @Override
    public Map<String, XrayTestStepResponseDto[]> getTestSteps(Collection<String> testIssueKeys) throws URISyntaxException, MissingConfigurationValueException {
        HashMap<String, XrayTestStepResponseDto[]> stepsByIssue = new HashMap<String, XrayTestStepResponseDto[]>();
        Map<String, String> issueIds = JiraIssueRepository.getInstance().getIssueIds(testIssueKeys);
        for (String testIssueKey : issueIds.keySet()) {
            RequestBuilder request = WebService.buildRequest((URI)this.getURITestSteps(testIssueKey));
            request.getBuilder().header("Authorization", (Object)this.getXrayAuthorizationHeaderValue()).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
            Response response = WebService.get((RequestBuilder)request);
            try {
                String responseData = (String)response.readEntity(String.class);
                if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                    String reason = String.format("%d %s: %s", response.getStatus(), response.getStatusInfo().getReasonPhrase(), responseData);
                    QtafFactory.getLogger().error(String.format("[QTAF Xray Plugin] Failed to retrieve test steps for issue %s: %s", testIssueKey, reason), new Object[0]);
                    continue;
                }
                XrayTestStepResponseDto[] steps = (XrayTestStepResponseDto[])GsonFactory.getInstance().fromJson(responseData, XrayServerTestStepResponseDto[].class);
                stepsByIssue.put(testIssueKey, steps);
            }
            finally {
                if (response == null) continue;
                response.close();
            }
        }
        return stepsByIssue;
    }

    private URI getURITestSteps(String testIssueKey) throws URISyntaxException {
        return new URI(String.format("%s/rest/raven/1.0/api/test/%s/step", this.getXrayURL(), testIssueKey));
    }

    @Generated
    XrayTestRepositoryServer() {
    }
}

