// Generated by delombok at Wed Sep 06 14:53:03 UTC 2023
package de.qytera.qtaf.xray.entity;

import de.qytera.qtaf.core.log.model.collection.TestScenarioLogCollection;
import de.qytera.qtaf.xray.config.XrayStatusHelper;
import java.util.ArrayList;
import java.util.List;

/**
 * Xray test entity.
 *
 * @see <a href="https://docs.getxray.app/display/XRAY/Import+Execution+Results#ImportExecutionResults-XrayJSONSchema">Xray Server JSON format</a>
 * @see <a href="https://docs.getxray.app/display/XRAYCLOUD/Using+Xray+JSON+format+to+import+execution+results">Xray Cloud JSON format</a>
 */
public class XrayTestEntity {
    /**
     * The test issue key.
     */
    private String testKey;
    /**
     * The testInfo element.
     */
    private XrayTestInfoEntity testInfo;
    /**
     * The start date for the test run.
     */
    private String start;
    /**
     * The finish date for the test run.
     */
    private String finish;
    /**
     * The comment for the test run.
     */
    private String comment;
    /**
     * The user id who executed the test run.
     */
    private String executedBy;
    /**
     * The user id for the assignee of the test run.
     */
    private String assignee;
    /**
     * The test run status (PASS, FAIL, EXECUTING, TO DO, custom statuses ...).
     */
    private final String status;
    /**
     * The step results.
     */
    private List<XrayManualTestStepResultEntity> steps = new ArrayList<>();
    /**
     * The example results for BDD tests (link).
     */
    private List<String> examples = new ArrayList<>();
    /**
     * The iteration containing data-driven test results.
     */
    private List<XrayIterationResultEntity> iterations = new ArrayList<>();
    /**
     * An array of defect issue keys to associate with the test run.
     */
    private List<String> defects = new ArrayList<>();
    /**
     * An array of evidence items of the test run.
     */
    private List<XrayEvidenceItemEntity> evidence = new ArrayList<>();
    /**
     * An array of custom fields for the test run.
     */
    private List<XrayCustomFieldEntity> customFields = new ArrayList<>();

    /**
     * Create a new {@link XrayTestEntity} with the given status.
     *
     * @param status the status
     */
    public XrayTestEntity(TestScenarioLogCollection.Status status) {
        this.status = XrayStatusHelper.statusToText(status);
    }

    /**
     * The test issue key.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTestKey() {
        return this.testKey;
    }

    /**
     * The testInfo element.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public XrayTestInfoEntity getTestInfo() {
        return this.testInfo;
    }

    /**
     * The start date for the test run.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStart() {
        return this.start;
    }

    /**
     * The finish date for the test run.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getFinish() {
        return this.finish;
    }

    /**
     * The comment for the test run.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getComment() {
        return this.comment;
    }

    /**
     * The user id who executed the test run.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getExecutedBy() {
        return this.executedBy;
    }

    /**
     * The user id for the assignee of the test run.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAssignee() {
        return this.assignee;
    }

    /**
     * The test run status (PASS, FAIL, EXECUTING, TO DO, custom statuses ...).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStatus() {
        return this.status;
    }

    /**
     * The step results.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<XrayManualTestStepResultEntity> getSteps() {
        return this.steps;
    }

    /**
     * The example results for BDD tests (link).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getExamples() {
        return this.examples;
    }

    /**
     * The iteration containing data-driven test results.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<XrayIterationResultEntity> getIterations() {
        return this.iterations;
    }

    /**
     * An array of defect issue keys to associate with the test run.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getDefects() {
        return this.defects;
    }

    /**
     * An array of evidence items of the test run.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<XrayEvidenceItemEntity> getEvidence() {
        return this.evidence;
    }

    /**
     * An array of custom fields for the test run.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<XrayCustomFieldEntity> getCustomFields() {
        return this.customFields;
    }

    /**
     * The test issue key.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTestKey(final String testKey) {
        this.testKey = testKey;
    }

    /**
     * The testInfo element.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTestInfo(final XrayTestInfoEntity testInfo) {
        this.testInfo = testInfo;
    }

    /**
     * The start date for the test run.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStart(final String start) {
        this.start = start;
    }

    /**
     * The finish date for the test run.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFinish(final String finish) {
        this.finish = finish;
    }

    /**
     * The comment for the test run.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setComment(final String comment) {
        this.comment = comment;
    }

    /**
     * The user id who executed the test run.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setExecutedBy(final String executedBy) {
        this.executedBy = executedBy;
    }

    /**
     * The user id for the assignee of the test run.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAssignee(final String assignee) {
        this.assignee = assignee;
    }

    /**
     * The step results.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSteps(final List<XrayManualTestStepResultEntity> steps) {
        this.steps = steps;
    }

    /**
     * The example results for BDD tests (link).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setExamples(final List<String> examples) {
        this.examples = examples;
    }

    /**
     * The iteration containing data-driven test results.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setIterations(final List<XrayIterationResultEntity> iterations) {
        this.iterations = iterations;
    }

    /**
     * An array of defect issue keys to associate with the test run.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDefects(final List<String> defects) {
        this.defects = defects;
    }

    /**
     * An array of evidence items of the test run.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setEvidence(final List<XrayEvidenceItemEntity> evidence) {
        this.evidence = evidence;
    }

    /**
     * An array of custom fields for the test run.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCustomFields(final List<XrayCustomFieldEntity> customFields) {
        this.customFields = customFields;
    }
}
