/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.xray.config;

import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.config.entity.ConfigMap;
import lombok.Generated;

public class XrayConfigHelper {
    private static final ConfigMap CONFIG = QtafFactory.getConfiguration();
    public static final String XRAY_ENABLED = "xray.enabled";
    public static final String XRAY_SERVICE = "xray.service";
    public static final String URL_XRAY_SELECTOR = "xray.url.xray";
    public static final String URL_JIRA_SELECTOR = "xray.url.jira";
    public static final String PROJECT_KEY = "xray.projectKey";
    public static final String AUTHENTICATION_XRAY_CLIENT_ID = "xray.authentication.xray.clientId";
    public static final String AUTHENTICATION_XRAY_CLIENT_SECRET = "xray.authentication.xray.clientSecret";
    public static final String AUTHENTICATION_XRAY_BEARER_TOKEN = "xray.authentication.xray.bearerToken";
    public static final String AUTHENTICATION_JIRA_USERNAME = "xray.authentication.jira.username";
    public static final String AUTHENTICATION_JIRA_API_TOKEN = "xray.authentication.jira.apiToken";
    public static final String RESULTS_UPLOAD_ASSIGNEE = "xray.resultsUpload.assignee";
    public static final String RESULTS_UPLOAD_TEST_PLAN_KEY = "xray.resultsUpload.testPlanKey";
    public static final String RESULTS_UPLOAD_SCENARIO_REPORT_EVIDENCE = "xray.resultsUpload.scenarioReportEvidence";
    public static final String RESULTS_UPLOAD_SCENARIO_IMAGE_EVIDENCE = "xray.resultsUpload.scenarioImageEvidence";
    public static final String RESULTS_UPLOAD_CUSTOM_STATUS_TEST_EXECUTION_ISSUE_PASSED = "xray.resultsUpload.customStatus.testExecutionIssue.passed";
    public static final String RESULTS_UPLOAD_CUSTOM_STATUS_TEST_EXECUTION_ISSUE_FAILED = "xray.resultsUpload.customStatus.testExecutionIssue.failed";
    public static final String RESULTS_UPLOAD_CUSTOM_STATUS_TEST_PASSED = "xray.resultsUpload.customStatus.test.passed";
    public static final String RESULTS_UPLOAD_CUSTOM_STATUS_TEST_FAILED = "xray.resultsUpload.customStatus.test.failed";
    public static final String RESULTS_UPLOAD_CUSTOM_STATUS_TEST_PENDING = "xray.resultsUpload.customStatus.test.pending";
    public static final String RESULTS_UPLOAD_CUSTOM_STATUS_TEST_SKIPPED = "xray.resultsUpload.customStatus.test.skipped";
    public static final String RESULTS_UPLOAD_CUSTOM_STATUS_STEP_PASSED = "xray.resultsUpload.customStatus.step.passed";
    public static final String RESULTS_UPLOAD_CUSTOM_STATUS_STEP_FAILED = "xray.resultsUpload.customStatus.step.failed";
    public static final String RESULTS_UPLOAD_CUSTOM_STATUS_STEP_PENDING = "xray.resultsUpload.customStatus.step.pending";
    public static final String RESULTS_UPLOAD_CUSTOM_STATUS_STEP_SKIPPED = "xray.resultsUpload.customStatus.step.skipped";
    public static final String RESULTS_UPLOAD_CUSTOM_STATUS_STEP_UNDEFINED = "xray.resultsUpload.customStatus.step.undefined";
    public static final String RESULTS_UPLOAD_TESTS_INFO_STEPS_UPDATE = "xray.resultsUpload.tests.info.steps.update";
    public static final String RESULTS_UPLOAD_TESTS_INFO_STEPS_MERGE = "xray.resultsUpload.tests.info.steps.merge";
    public static final String RESULTS_UPLOAD_TESTS_INFO_KEEP_JIRA_SUMMARY = "xray.resultsUpload.tests.info.keepJiraSummary";
    public static final String RESULTS_UPLOAD_TESTS_ITERATIONS_PARAMETERS_MAX_LENGTH_NAME = "xray.resultsUpload.tests.iterations.parameters.maxLength.name";
    public static final String RESULTS_UPLOAD_TESTS_ITERATIONS_PARAMETERS_MAX_LENGTH_VALUE = "xray.resultsUpload.tests.iterations.parameters.maxLength.value";
    public static final String XRAY_SERVICE_CLOUD = "cloud";
    public static final String XRAY_SERVICE_SERVER = "server";

    public static boolean isEnabled() {
        return CONFIG.getBoolean(XRAY_ENABLED, Boolean.valueOf(false));
    }

    public static String getAuthenticationXrayBearerToken() {
        return CONFIG.getString(AUTHENTICATION_XRAY_BEARER_TOKEN);
    }

    public static String getAuthenticationXrayClientId() {
        return CONFIG.getString(AUTHENTICATION_XRAY_CLIENT_ID);
    }

    public static String getAuthenticationXrayClientSecret() {
        return CONFIG.getString(AUTHENTICATION_XRAY_CLIENT_SECRET);
    }

    public static String getAuthenticationJiraUsername() {
        return CONFIG.getString(AUTHENTICATION_JIRA_USERNAME);
    }

    public static String getAuthenticationJiraAPIToken() {
        return CONFIG.getString(AUTHENTICATION_JIRA_API_TOKEN);
    }

    public static String getServerUrl() {
        return CONFIG.getString(URL_XRAY_SELECTOR);
    }

    public static String getJiraUrl() {
        return CONFIG.getString(URL_JIRA_SELECTOR);
    }

    public static String getResultsUploadCustomStatusTestExecutionIssuePassed() {
        return CONFIG.getString(RESULTS_UPLOAD_CUSTOM_STATUS_TEST_EXECUTION_ISSUE_PASSED);
    }

    public static String getResultsUploadCustomStatusTestExecutionIssueFailed() {
        return CONFIG.getString(RESULTS_UPLOAD_CUSTOM_STATUS_TEST_EXECUTION_ISSUE_FAILED);
    }

    public static String getTestStatusPassed() {
        return CONFIG.getString(RESULTS_UPLOAD_CUSTOM_STATUS_TEST_PASSED);
    }

    public static String getTestStatusFailed() {
        return CONFIG.getString(RESULTS_UPLOAD_CUSTOM_STATUS_TEST_FAILED);
    }

    public static String getTestStatusPending() {
        return CONFIG.getString(RESULTS_UPLOAD_CUSTOM_STATUS_TEST_PENDING);
    }

    public static String getTestStatusSkipped() {
        return CONFIG.getString(RESULTS_UPLOAD_CUSTOM_STATUS_TEST_SKIPPED);
    }

    public static String getStepStatusPassed() {
        return CONFIG.getString(RESULTS_UPLOAD_CUSTOM_STATUS_STEP_PASSED);
    }

    public static String getStepStatusFailed() {
        return CONFIG.getString(RESULTS_UPLOAD_CUSTOM_STATUS_STEP_FAILED);
    }

    public static String getStepStatusPending() {
        return CONFIG.getString(RESULTS_UPLOAD_CUSTOM_STATUS_STEP_PENDING);
    }

    public static String getStepStatusSkipped() {
        return CONFIG.getString(RESULTS_UPLOAD_CUSTOM_STATUS_STEP_SKIPPED);
    }

    public static String getStepStatusUndefined() {
        return CONFIG.getString(RESULTS_UPLOAD_CUSTOM_STATUS_STEP_UNDEFINED);
    }

    public static String getXrayService() {
        String service = CONFIG.getString(XRAY_SERVICE);
        if (service == null) {
            CONFIG.logMissingValue(XRAY_SERVICE, (Object)XRAY_SERVICE_CLOUD);
            return XRAY_SERVICE_CLOUD;
        }
        if (service.equals(XRAY_SERVICE_SERVER) || service.equals(XRAY_SERVICE_CLOUD)) {
            return service;
        }
        return (String)CONFIG.logUnknownValue(XRAY_SERVICE, (Object)service, (Object)XRAY_SERVICE_CLOUD, (Object[])new String[]{XRAY_SERVICE_SERVER, XRAY_SERVICE_CLOUD});
    }

    public static boolean isXrayServerService() {
        return XrayConfigHelper.getXrayService().equals(XRAY_SERVICE_SERVER);
    }

    public static boolean isXrayCloudService() {
        return XrayConfigHelper.getXrayService().equals(XRAY_SERVICE_CLOUD);
    }

    public static boolean isScenarioReportEvidenceEnabled() {
        Boolean value = CONFIG.getBoolean(RESULTS_UPLOAD_SCENARIO_REPORT_EVIDENCE);
        if (value == null) {
            return (Boolean)CONFIG.logMissingValue(RESULTS_UPLOAD_SCENARIO_REPORT_EVIDENCE, (Object)false);
        }
        return value;
    }

    public static boolean isScenarioImageEvidenceEnabled() {
        Boolean value = CONFIG.getBoolean(RESULTS_UPLOAD_SCENARIO_IMAGE_EVIDENCE);
        if (value == null) {
            return (Boolean)CONFIG.logMissingValue(RESULTS_UPLOAD_SCENARIO_IMAGE_EVIDENCE, (Object)false);
        }
        return value;
    }

    public static Integer getTestsIterationsParametersNameMaxLength() {
        return CONFIG.getInt(RESULTS_UPLOAD_TESTS_ITERATIONS_PARAMETERS_MAX_LENGTH_NAME);
    }

    public static Integer getTestsIterationsParametersValueMaxLength() {
        return CONFIG.getInt(RESULTS_UPLOAD_TESTS_ITERATIONS_PARAMETERS_MAX_LENGTH_VALUE);
    }

    public static boolean shouldResultsUploadTestsInfoStepsMerge() {
        Boolean value = CONFIG.getBoolean(RESULTS_UPLOAD_TESTS_INFO_STEPS_MERGE);
        if (value == null) {
            return (Boolean)CONFIG.logMissingValue(RESULTS_UPLOAD_TESTS_INFO_STEPS_MERGE, (Object)false);
        }
        return value;
    }

    public static boolean shouldResultsUploadTestsInfoStepsUpdate() {
        Boolean value = CONFIG.getBoolean(RESULTS_UPLOAD_TESTS_INFO_STEPS_UPDATE);
        if (value == null) {
            return (Boolean)CONFIG.logMissingValue(RESULTS_UPLOAD_TESTS_INFO_STEPS_UPDATE, (Object)false);
        }
        return value;
    }

    public static boolean shouldResultsUploadTestsInfoKeepJiraSummary() {
        Boolean value = CONFIG.getBoolean(RESULTS_UPLOAD_TESTS_INFO_KEEP_JIRA_SUMMARY);
        if (value == null) {
            return (Boolean)CONFIG.logMissingValue(RESULTS_UPLOAD_TESTS_INFO_KEEP_JIRA_SUMMARY, (Object)false);
        }
        return value;
    }

    public static String getProjectKey() {
        return CONFIG.getString(PROJECT_KEY);
    }

    public static String getResultsUploadTestPlanKey() {
        return CONFIG.getString(RESULTS_UPLOAD_TEST_PLAN_KEY);
    }

    public static String getResultsUploadAssignee() {
        return CONFIG.getString(RESULTS_UPLOAD_ASSIGNEE);
    }

    @Generated
    private XrayConfigHelper() {
    }
}

