/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.xray.event_subscriber;

import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.config.exception.MissingConfigurationValueException;
import de.qytera.qtaf.core.events.QtafEvents;
import de.qytera.qtaf.core.events.interfaces.IEventSubscriber;
import de.qytera.qtaf.core.events.payload.IQtafTestingContext;
import de.qytera.qtaf.core.log.Logger;
import de.qytera.qtaf.xray.builder.XrayJsonImportBuilder;
import de.qytera.qtaf.xray.config.XrayConfigHelper;
import de.qytera.qtaf.xray.dto.request.xray.ImportExecutionResultsRequestDto;
import de.qytera.qtaf.xray.dto.response.xray.ImportExecutionResultsResponseDto;
import de.qytera.qtaf.xray.events.XrayEvents;
import de.qytera.qtaf.xray.repository.jira.JiraIssueRepository;
import de.qytera.qtaf.xray.repository.xray.XrayTestRepository;
import rx.Subscription;

public class UploadResultsSubscriber
implements IEventSubscriber {
    private boolean uploaded = false;
    private Subscription testFinishedSubscription;
    private static final Logger logger = QtafFactory.getLogger();

    public void initialize() {
        if (this.testFinishedSubscription != null) {
            return;
        }
        this.testFinishedSubscription = QtafEvents.finishedTesting.subscribe(this::onTestFinished);
    }

    private void onTestFinished(IQtafTestingContext testContext) {
        if (!XrayConfigHelper.isEnabled()) {
            return;
        }
        if (this.uploaded) {
            return;
        }
        this.uploaded = true;
        logger.info("[QTAF Xray Plugin] Uploading Xray results ...", new Object[0]);
        try {
            if (XrayConfigHelper.getProjectKey() == null) {
                throw new MissingConfigurationValueException("xray.projectKey", QtafFactory.getConfiguration());
            }
            ImportExecutionResultsRequestDto xrayImportRequestDto = new XrayJsonImportBuilder(QtafFactory.getTestSuiteLogCollection(), JiraIssueRepository.getInstance()).build();
            XrayEvents.importDtoCreated.onNext((Object)xrayImportRequestDto);
            ImportExecutionResultsResponseDto responseDto = XrayTestRepository.getInstance().importExecutionResults(xrayImportRequestDto);
            String key = responseDto.getKey();
            logger.info(String.format("[QTAF Xray Plugin] Uploaded test execution. Key is %s", key), new Object[0]);
            XrayEvents.responseDtoAvailable.onNext((Object)responseDto);
            XrayEvents.responseDtoAvailable.onCompleted();
        }
        catch (XrayJsonImportBuilder.NoXrayTestException e) {
            logger.info("[QTAF Xray Plugin] No tests linked to Xray issues were executed. Skipping upload.", new Object[0]);
        }
        catch (Exception e) {
            logger.error((Throwable)e, new Object[0]);
        }
    }
}

