// Generated by delombok at Wed Sep 13 14:56:56 UTC 2023
package de.qytera.qtaf.xray.dto.jira;

import java.util.ArrayList;
import java.util.List;

/**
 * This resource represents application roles. Use it to get details of an application role or all application roles.
 *
 * @see <a href="https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-application-roles/#api-rest-api-3-applicationrole-key-get">Get application role (Jira cloud)</a>
 * @see <a href="https://docs.atlassian.com/software/jira/docs/api/REST/9.7.0/#api/2/applicationrole-get">Get application role (Jira server)</a>
 */
public abstract class ApplicationRoleDto {
    /**
     * The key of the application role.
     */
    private String key;
    /**
     * The groups associated with the application role.
     */
    private List<String> groups = new ArrayList<>();
    /**
     * The display name of the application role.
     */
    private String name;
    /**
     * The groups that are granted default access for this application role.
     */
    private List<String> defaultGroups = new ArrayList<>();
    /**
     * Determines whether this application role should be selected by default on user creation.
     */
    private Boolean selectedByDefault;
    /**
     * The maximum count of users on your license.
     */
    private Integer numberOfSeats;
    /**
     * The count of users remaining on your license.
     */
    private Integer remainingSeats;
    /**
     * The number of users counting against your license.
     */
    private Integer userCount;
    /**
     * The <a href="https://confluence.atlassian.com/x/lRW3Ng">type of users</a> being counted against your license.
     */
    private String userCountDescription;
    /**
     * Whether the application role has unlimited seats.
     */
    private Boolean hasUnlimitedSeats;
    /**
     * Indicates if the application role belongs to Jira platform (jira-core).
     */
    private Boolean platform;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ApplicationRoleDto() {
    }

    /**
     * The key of the application role.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getKey() {
        return this.key;
    }

    /**
     * The groups associated with the application role.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getGroups() {
        return this.groups;
    }

    /**
     * The display name of the application role.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getName() {
        return this.name;
    }

    /**
     * The groups that are granted default access for this application role.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getDefaultGroups() {
        return this.defaultGroups;
    }

    /**
     * Determines whether this application role should be selected by default on user creation.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getSelectedByDefault() {
        return this.selectedByDefault;
    }

    /**
     * The maximum count of users on your license.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getNumberOfSeats() {
        return this.numberOfSeats;
    }

    /**
     * The count of users remaining on your license.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getRemainingSeats() {
        return this.remainingSeats;
    }

    /**
     * The number of users counting against your license.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getUserCount() {
        return this.userCount;
    }

    /**
     * The <a href="https://confluence.atlassian.com/x/lRW3Ng">type of users</a> being counted against your license.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUserCountDescription() {
        return this.userCountDescription;
    }

    /**
     * Whether the application role has unlimited seats.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getHasUnlimitedSeats() {
        return this.hasUnlimitedSeats;
    }

    /**
     * Indicates if the application role belongs to Jira platform (jira-core).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getPlatform() {
        return this.platform;
    }

    /**
     * The key of the application role.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setKey(final String key) {
        this.key = key;
    }

    /**
     * The groups associated with the application role.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setGroups(final List<String> groups) {
        this.groups = groups;
    }

    /**
     * The display name of the application role.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setName(final String name) {
        this.name = name;
    }

    /**
     * The groups that are granted default access for this application role.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDefaultGroups(final List<String> defaultGroups) {
        this.defaultGroups = defaultGroups;
    }

    /**
     * Determines whether this application role should be selected by default on user creation.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSelectedByDefault(final Boolean selectedByDefault) {
        this.selectedByDefault = selectedByDefault;
    }

    /**
     * The maximum count of users on your license.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setNumberOfSeats(final Integer numberOfSeats) {
        this.numberOfSeats = numberOfSeats;
    }

    /**
     * The count of users remaining on your license.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRemainingSeats(final Integer remainingSeats) {
        this.remainingSeats = remainingSeats;
    }

    /**
     * The number of users counting against your license.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUserCount(final Integer userCount) {
        this.userCount = userCount;
    }

    /**
     * The <a href="https://confluence.atlassian.com/x/lRW3Ng">type of users</a> being counted against your license.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUserCountDescription(final String userCountDescription) {
        this.userCountDescription = userCountDescription;
    }

    /**
     * Whether the application role has unlimited seats.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setHasUnlimitedSeats(final Boolean hasUnlimitedSeats) {
        this.hasUnlimitedSeats = hasUnlimitedSeats;
    }

    /**
     * Indicates if the application role belongs to Jira platform (jira-core).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPlatform(final Boolean platform) {
        this.platform = platform;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ApplicationRoleDto)) return false;
        final ApplicationRoleDto other = (ApplicationRoleDto) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$selectedByDefault = this.getSelectedByDefault();
        final java.lang.Object other$selectedByDefault = other.getSelectedByDefault();
        if (this$selectedByDefault == null ? other$selectedByDefault != null : !this$selectedByDefault.equals(other$selectedByDefault)) return false;
        final java.lang.Object this$numberOfSeats = this.getNumberOfSeats();
        final java.lang.Object other$numberOfSeats = other.getNumberOfSeats();
        if (this$numberOfSeats == null ? other$numberOfSeats != null : !this$numberOfSeats.equals(other$numberOfSeats)) return false;
        final java.lang.Object this$remainingSeats = this.getRemainingSeats();
        final java.lang.Object other$remainingSeats = other.getRemainingSeats();
        if (this$remainingSeats == null ? other$remainingSeats != null : !this$remainingSeats.equals(other$remainingSeats)) return false;
        final java.lang.Object this$userCount = this.getUserCount();
        final java.lang.Object other$userCount = other.getUserCount();
        if (this$userCount == null ? other$userCount != null : !this$userCount.equals(other$userCount)) return false;
        final java.lang.Object this$hasUnlimitedSeats = this.getHasUnlimitedSeats();
        final java.lang.Object other$hasUnlimitedSeats = other.getHasUnlimitedSeats();
        if (this$hasUnlimitedSeats == null ? other$hasUnlimitedSeats != null : !this$hasUnlimitedSeats.equals(other$hasUnlimitedSeats)) return false;
        final java.lang.Object this$platform = this.getPlatform();
        final java.lang.Object other$platform = other.getPlatform();
        if (this$platform == null ? other$platform != null : !this$platform.equals(other$platform)) return false;
        final java.lang.Object this$key = this.getKey();
        final java.lang.Object other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) return false;
        final java.lang.Object this$groups = this.getGroups();
        final java.lang.Object other$groups = other.getGroups();
        if (this$groups == null ? other$groups != null : !this$groups.equals(other$groups)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$defaultGroups = this.getDefaultGroups();
        final java.lang.Object other$defaultGroups = other.getDefaultGroups();
        if (this$defaultGroups == null ? other$defaultGroups != null : !this$defaultGroups.equals(other$defaultGroups)) return false;
        final java.lang.Object this$userCountDescription = this.getUserCountDescription();
        final java.lang.Object other$userCountDescription = other.getUserCountDescription();
        if (this$userCountDescription == null ? other$userCountDescription != null : !this$userCountDescription.equals(other$userCountDescription)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ApplicationRoleDto;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $selectedByDefault = this.getSelectedByDefault();
        result = result * PRIME + ($selectedByDefault == null ? 43 : $selectedByDefault.hashCode());
        final java.lang.Object $numberOfSeats = this.getNumberOfSeats();
        result = result * PRIME + ($numberOfSeats == null ? 43 : $numberOfSeats.hashCode());
        final java.lang.Object $remainingSeats = this.getRemainingSeats();
        result = result * PRIME + ($remainingSeats == null ? 43 : $remainingSeats.hashCode());
        final java.lang.Object $userCount = this.getUserCount();
        result = result * PRIME + ($userCount == null ? 43 : $userCount.hashCode());
        final java.lang.Object $hasUnlimitedSeats = this.getHasUnlimitedSeats();
        result = result * PRIME + ($hasUnlimitedSeats == null ? 43 : $hasUnlimitedSeats.hashCode());
        final java.lang.Object $platform = this.getPlatform();
        result = result * PRIME + ($platform == null ? 43 : $platform.hashCode());
        final java.lang.Object $key = this.getKey();
        result = result * PRIME + ($key == null ? 43 : $key.hashCode());
        final java.lang.Object $groups = this.getGroups();
        result = result * PRIME + ($groups == null ? 43 : $groups.hashCode());
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $defaultGroups = this.getDefaultGroups();
        result = result * PRIME + ($defaultGroups == null ? 43 : $defaultGroups.hashCode());
        final java.lang.Object $userCountDescription = this.getUserCountDescription();
        result = result * PRIME + ($userCountDescription == null ? 43 : $userCountDescription.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "ApplicationRoleDto(key=" + this.getKey() + ", groups=" + this.getGroups() + ", name=" + this.getName() + ", defaultGroups=" + this.getDefaultGroups() + ", selectedByDefault=" + this.getSelectedByDefault() + ", numberOfSeats=" + this.getNumberOfSeats() + ", remainingSeats=" + this.getRemainingSeats() + ", userCount=" + this.getUserCount() + ", userCountDescription=" + this.getUserCountDescription() + ", hasUnlimitedSeats=" + this.getHasUnlimitedSeats() + ", platform=" + this.getPlatform() + ")";
    }
}
