/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.xray.builder.test;

import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.log.model.collection.TestScenarioLogCollection;
import de.qytera.qtaf.core.log.model.collection.TestSuiteLogCollection;
import de.qytera.qtaf.core.log.model.message.StepInformationLogMessage;
import de.qytera.qtaf.htmlreport.creator.ScenarioReportCreator;
import de.qytera.qtaf.xray.annotation.XrayTest;
import de.qytera.qtaf.xray.builder.XrayJsonHelper;
import de.qytera.qtaf.xray.config.XrayConfigHelper;
import de.qytera.qtaf.xray.config.XrayStatusHelper;
import de.qytera.qtaf.xray.entity.XrayCustomFieldEntity;
import de.qytera.qtaf.xray.entity.XrayEvidenceItemEntity;
import de.qytera.qtaf.xray.entity.XrayIterationResultEntity;
import de.qytera.qtaf.xray.entity.XrayManualTestStepResultEntity;
import de.qytera.qtaf.xray.entity.XrayManualTestStepResultEntityCloud;
import de.qytera.qtaf.xray.entity.XrayManualTestStepResultEntityServer;
import de.qytera.qtaf.xray.entity.XrayTestEntity;
import de.qytera.qtaf.xray.entity.XrayTestInfoEntity;
import de.qytera.qtaf.xray.entity.XrayTestStepEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.util.Strings;

public abstract class XrayTestEntityBuilder<T> {
    @NonNull
    protected TestSuiteLogCollection collection;
    protected final ScenarioReportCreator reportCreator = new ScenarioReportCreator();
    @NonNull
    protected Map<String, String> issueSummaries;

    public XrayTestEntity buildTestEntity(XrayTest xrayTest, T scenarioData) {
        XrayTestEntity entity = new XrayTestEntity(this.getStatus(xrayTest, scenarioData));
        entity.setTestKey(xrayTest.key());
        entity.setTestInfo(this.getTestInfo(xrayTest, scenarioData));
        entity.setStart(XrayJsonHelper.isoDateString(this.getStartDate(xrayTest, scenarioData)));
        entity.setFinish(XrayJsonHelper.isoDateString(this.getEndDate(xrayTest, scenarioData)));
        entity.setComment(this.getComment(xrayTest, scenarioData));
        entity.setExecutedBy(this.getExecutedBy(xrayTest, scenarioData));
        entity.setAssignee(this.getAssignee(xrayTest, scenarioData));
        if (scenarioData instanceof TestScenarioLogCollection) {
            entity.setSteps(this.getSteps(xrayTest, scenarioData));
        } else {
            entity.setSteps(null);
        }
        List<String> examples = this.getExamples(xrayTest, scenarioData);
        if (!examples.isEmpty()) {
            entity.setExamples(examples);
        } else {
            entity.setExamples(null);
        }
        if (scenarioData instanceof List) {
            entity.setIterations(this.getIterations(xrayTest, scenarioData));
        } else {
            entity.setIterations(null);
        }
        entity.setDefects(this.getDefects(xrayTest, scenarioData));
        entity.setEvidence(this.getEvidence(xrayTest, scenarioData));
        entity.setCustomFields(this.getCustomFields(xrayTest, scenarioData));
        return entity;
    }

    protected abstract TestScenarioLogCollection.Status getStatus(XrayTest var1, T var2);

    protected abstract XrayTestInfoEntity getTestInfo(XrayTest var1, T var2);

    protected abstract Date getStartDate(XrayTest var1, T var2);

    protected abstract Date getEndDate(XrayTest var1, T var2);

    protected abstract String getComment(XrayTest var1, T var2);

    protected abstract String getExecutedBy(XrayTest var1, T var2);

    protected abstract String getAssignee(XrayTest var1, T var2);

    protected abstract List<XrayManualTestStepResultEntity> getSteps(XrayTest var1, T var2);

    protected abstract List<String> getExamples(XrayTest var1, T var2);

    protected abstract List<XrayIterationResultEntity> getIterations(XrayTest var1, T var2);

    protected abstract List<String> getDefects(XrayTest var1, T var2);

    protected abstract List<XrayEvidenceItemEntity> getEvidence(XrayTest var1, T var2);

    protected abstract List<XrayCustomFieldEntity> getCustomFields(XrayTest var1, T var2);

    protected static XrayTestStepEntity buildTestStepEntity(StepInformationLogMessage stepLog) {
        XrayTestStepEntity entity = new XrayTestStepEntity(stepLog.getStep().getName());
        String data = stepLog.getStepParameters().stream().map(p -> {
            Object value = p.getValue();
            if (value instanceof Object[]) {
                Object[] array = (Object[])value;
                value = Arrays.toString(array);
            }
            return String.format("%s=%s", p.getName(), value);
        }).collect(Collectors.joining("\n"));
        if (!data.isBlank()) {
            entity.setData(data);
        }
        if (stepLog.getResult() != null) {
            entity.setResult(stepLog.getResult().toString());
        }
        return entity;
    }

    protected static XrayTestStepEntity buildMergedTestStepEntity(List<StepInformationLogMessage> steps) {
        ArrayList<String> linesAction = new ArrayList<String>();
        ArrayList<String> linesData = new ArrayList<String>();
        ArrayList<String> linesResult = new ArrayList<String>();
        if (steps.isEmpty()) {
            QtafFactory.getLogger().warn("Merging empty step log collection into single step", new Object[0]);
            linesAction.add("// no action defined");
            linesData.add("// no data defined");
            linesResult.add("// no result defined");
        } else {
            for (int i = 0; i < steps.size(); ++i) {
                StepInformationLogMessage step = steps.get(i);
                linesAction.add(XrayTestEntityBuilder.stepString(i, steps.size(), step.getStep().getName()));
                linesData.add(XrayTestEntityBuilder.stepString(i, steps.size(), XrayTestEntityBuilder.stepDataString(step)));
                linesResult.add(XrayTestEntityBuilder.stepString(i, steps.size(), step.getResult()));
            }
        }
        XrayTestStepEntity mergedStep = new XrayTestStepEntity(Strings.join(linesAction, (char)'\n'));
        mergedStep.setData(Strings.join(linesData, (char)'\n'));
        mergedStep.setResult(Strings.join(linesResult, (char)'\n'));
        return mergedStep;
    }

    protected static XrayManualTestStepResultEntity buildManualTestStepResultEntity(StepInformationLogMessage step) {
        XrayManualTestStepResultEntity entity = XrayConfigHelper.isXrayCloudService() ? new XrayManualTestStepResultEntityCloud(step.getStatus()) : new XrayManualTestStepResultEntityServer(step.getStatus());
        if (step.getStep() != null) {
            entity.setComment(step.getStep().getName());
        }
        if (step.getResult() != null) {
            entity.setActualResult(step.getResult().toString());
        }
        if (step.getScreenshotBefore() != null && !step.getScreenshotBefore().isBlank()) {
            entity.addEvidenceIfPresent(XrayEvidenceItemEntity.fromFile(step.getScreenshotBefore()));
        }
        if (step.getScreenshotAfter() != null && !step.getScreenshotAfter().isBlank()) {
            entity.addEvidenceIfPresent(XrayEvidenceItemEntity.fromFile(step.getScreenshotAfter()));
        }
        return entity;
    }

    protected static XrayManualTestStepResultEntity buildMergedManualTestStepResultEntity(List<StepInformationLogMessage> steps) {
        XrayManualTestStepResultEntity entity = XrayConfigHelper.isXrayCloudService() ? new XrayManualTestStepResultEntityCloud(XrayStatusHelper.combinedStepStatus(steps)) : new XrayManualTestStepResultEntityServer(XrayStatusHelper.combinedStepStatus(steps));
        List<XrayManualTestStepResultEntity> stepResults = steps.stream().map(XrayTestEntityBuilder::buildManualTestStepResultEntity).toList();
        String comment = IntStream.range(0, stepResults.size()).mapToObj(i -> XrayTestEntityBuilder.stepString(i, stepResults.size(), ((XrayManualTestStepResultEntity)stepResults.get(i)).getComment())).collect(Collectors.joining("\n"));
        List<String> defects = stepResults.stream().map(XrayManualTestStepResultEntity::getDefects).flatMap(Collection::stream).toList();
        String actualResult = IntStream.range(0, stepResults.size()).mapToObj(i -> XrayTestEntityBuilder.stepString(i, stepResults.size(), ((XrayManualTestStepResultEntity)stepResults.get(i)).getActualResult())).collect(Collectors.joining("\n"));
        List evidence = stepResults.stream().map(XrayManualTestStepResultEntity::getAllEvidence).flatMap(Collection::stream).toList();
        entity.setComment(comment);
        entity.setDefects(defects);
        entity.setActualResult(actualResult);
        entity.getAllEvidence().addAll(evidence);
        return entity;
    }

    private static String stepString(int stepNumber, int maxSteps, Object content) {
        String stepIndexFormat = "%0" + String.valueOf(maxSteps + 1).length() + "d";
        String lineFormat = stepIndexFormat + ": %s";
        return String.format(lineFormat, stepNumber + 1, content);
    }

    private static String stepDataString(StepInformationLogMessage step) {
        if (step.getStepParameters().isEmpty()) {
            return "<none>";
        }
        ArrayList<String> parameterStrings = new ArrayList<String>(step.getStepParameters().size());
        for (StepInformationLogMessage.StepParameter parameter : step.getStepParameters()) {
            Object value = parameter.getValue();
            if (value instanceof Object[]) {
                Object[] array = (Object[])value;
                value = Arrays.toString(array);
            }
            parameterStrings.add(String.format("%s=%s", parameter.getName(), value));
        }
        return Strings.join(parameterStrings, (char)'\n');
    }

    @Generated
    protected XrayTestEntityBuilder(@NonNull TestSuiteLogCollection collection, @NonNull Map<String, String> issueSummaries) {
        if (collection == null) {
            throw new NullPointerException("collection is marked non-null but is null");
        }
        if (issueSummaries == null) {
            throw new NullPointerException("issueSummaries is marked non-null but is null");
        }
        this.collection = collection;
        this.issueSummaries = issueSummaries;
    }
}

