/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.xray.event_subscriber;

import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.config.exception.MissingConfigurationValueException;
import de.qytera.qtaf.core.events.interfaces.IEventSubscriber;
import de.qytera.qtaf.xray.config.XrayConfigHelper;
import de.qytera.qtaf.xray.dto.jira.UserCloudDto;
import de.qytera.qtaf.xray.dto.jira.UserDto;
import de.qytera.qtaf.xray.dto.jira.UserServerDto;
import de.qytera.qtaf.xray.dto.response.xray.ImportExecutionResultsResponseDto;
import de.qytera.qtaf.xray.events.XrayEvents;
import de.qytera.qtaf.xray.repository.jira.JiraIssueRepository;
import java.net.URISyntaxException;
import rx.Subscription;

public class AssignTestExecutionIssueSubscriber
implements IEventSubscriber {
    private Subscription subscription;

    public void initialize() {
        if (this.subscription == null) {
            this.subscription = XrayEvents.responseDtoAvailable.subscribe(AssignTestExecutionIssueSubscriber::onResultsImport);
        }
    }

    private static void onResultsImport(ImportExecutionResultsResponseDto response) {
        UserDto user;
        String assignee = XrayConfigHelper.getResultsUploadAssignee();
        if (assignee == null) {
            return;
        }
        if (XrayConfigHelper.isXrayCloudService()) {
            dto = new UserCloudDto();
            ((UserCloudDto)dto).setAccountId(assignee);
            user = dto;
        } else {
            dto = new UserServerDto();
            ((UserServerDto)dto).setName(assignee);
            user = dto;
        }
        try {
            QtafFactory.getLogger().info(String.format("[QTAF Xray Plugin] Assigning issue '%s' to '%s'...", response.getKey(), user), new Object[0]);
            if (!JiraIssueRepository.getInstance().assign(response.getKey(), user)) {
                QtafFactory.getLogger().warn(String.format("[QTAF Xray Plugin] Failed to assign issue '%s' to '%s'. Please verify your configuration.", response.getKey(), user), new Object[0]);
            }
        }
        catch (MissingConfigurationValueException | URISyntaxException exception) {
            QtafFactory.getLogger().error(exception, new Object[0]);
        }
    }
}

