/*
 * Decompiled with CFR 0.152.
 */
package de.raptaml.ninja.hazelcast.embedded;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.hazelcast.config.Config;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.InterfacesConfig;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import ninja.cache.Cache;
import ninja.lifecycle.Dispose;
import ninja.utils.NinjaProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CacheHazelcastImpl
implements Cache {
    private static final Logger LOG = LoggerFactory.getLogger(CacheHazelcastImpl.class);
    private final NinjaProperties ninjaProperties;
    private final String bindAdress;
    private final int bindPort;
    private final String multicastAddress;
    private final String groupName;
    private final String groupSecret;
    private final HazelcastInstance instance;
    private final Config config;
    private final NetworkConfig network;
    private final GroupConfig group;
    private final IMap<String, Object> cache;

    @Inject
    public CacheHazelcastImpl(NinjaProperties ninjaProperties) throws Exception {
        this.ninjaProperties = ninjaProperties;
        this.bindAdress = ninjaProperties.getOrDie("ninja.hazelcast.interface_ip");
        this.bindPort = ninjaProperties.getIntegerOrDie("ninja.hazelcast.outbound_port");
        this.multicastAddress = ninjaProperties.getWithDefault("ninja.hazelcast.multicast_address", "224.0.0.1");
        this.groupName = ninjaProperties.getOrDie("ninja.hazelcast.groupname");
        this.groupSecret = ninjaProperties.getOrDie("ninja.hazelcast.groupsecret");
        this.config = new Config();
        this.network = new NetworkConfig().setInterfaces(new InterfacesConfig().clear().addInterface(this.bindAdress).setEnabled(true)).setPort(this.bindPort);
        JoinConfig joinConfig = new JoinConfig().setMulticastConfig(new MulticastConfig().setEnabled(true).setMulticastGroup(this.multicastAddress));
        this.network.setJoin(joinConfig);
        this.group = new GroupConfig(this.groupName, this.groupSecret);
        this.config.setNetworkConfig(this.network);
        this.config.setGroupConfig(this.group);
        this.config.setProperty("hazelcast.socket.bind.any", "false");
        this.instance = Hazelcast.newHazelcastInstance((Config)this.config);
        this.cache = this.instance.getMap("cache");
    }

    public void add(String key, Object value, int expiration) {
        this.cache.putIfAbsent((Object)key, value, (long)expiration, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean safeAdd(String key, Object value, int expiration) {
        try {
            if (!this.cache.tryLock((Object)key, 2L, TimeUnit.SECONDS)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.cache.putIfAbsent((Object)key, value, (long)expiration, TimeUnit.SECONDS) == null;
            return bl;
        }
        catch (InterruptedException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.cache.unlock((Object)key);
        }
    }

    public void set(String key, Object value, int expiration) {
        this.cache.set((Object)key, value, (long)expiration, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean safeSet(String key, Object value, int expiration) {
        boolean bl;
        if (!this.cache.tryLock((Object)key, 2L, TimeUnit.SECONDS)) {
            return false;
        }
        try {
            this.cache.set((Object)key, value, (long)expiration, TimeUnit.SECONDS);
            bl = this.cache.get((Object)key).equals(value);
        }
        catch (Throwable throwable) {
            try {
                this.cache.unlock((Object)key);
                throw throwable;
            }
            catch (Exception e) {
                return false;
            }
        }
        this.cache.unlock((Object)key);
        return bl;
    }

    public void replace(String key, Object value, int expiration) {
        if (this.cache.containsKey((Object)key)) {
            this.cache.set((Object)key, value, (long)expiration, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean safeReplace(String key, Object value, int expiration) {
        try {
            if (!this.cache.tryLock((Object)key, 2L, TimeUnit.SECONDS)) {
                return false;
            }
            try {
                Object oldValue = this.cache.get((Object)key);
                if (this.cache.containsKey((Object)key) && this.cache.get((Object)key).equals(oldValue)) {
                    this.cache.set((Object)key, value, (long)expiration, TimeUnit.SECONDS);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.cache.unlock((Object)key);
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    public Object get(String key) {
        return this.cache.get((Object)key);
    }

    public Map<String, Object> get(String[] keys) {
        return this.cache.getAll(new LinkedHashSet<String>(Arrays.asList(keys)));
    }

    public long incr(String key, int by) {
        if (!this.cache.tryLock((Object)key)) {
            throw new IllegalStateException("The specified key is locked by another thread");
        }
        try {
            this.cache.get((Object)key).getClass().asSubclass(Long.class);
            long num = (Long)this.cache.get((Object)key);
            long l = (Long)this.cache.put((Object)key, (Object)(num += (long)by));
            return l;
        }
        catch (ClassCastException e) {
            throw new ClassCastException("Can only increment subtype of Long");
        }
        finally {
            this.cache.unlock((Object)key);
        }
    }

    public long decr(String key, int by) {
        if (!this.cache.tryLock((Object)key)) {
            throw new IllegalStateException("The specified key is locked by another thread");
        }
        try {
            this.cache.get((Object)key).getClass().asSubclass(Long.class);
            long num = (Long)this.cache.get((Object)key);
            long l = (Long)this.cache.put((Object)key, (Object)(num -= (long)by));
            return l;
        }
        catch (ClassCastException e) {
            throw new ClassCastException("Can only decrement subtype of Long");
        }
        finally {
            this.cache.unlock((Object)key);
        }
    }

    public void clear() {
        this.cache.clear();
    }

    public void delete(String key) {
        this.cache.delete((Object)key);
    }

    public boolean safeDelete(String key) {
        return this.cache.tryRemove((Object)key, 2L, TimeUnit.SECONDS);
    }

    @Dispose
    public void stop() {
        if (this.instance != null) {
            this.instance.shutdown();
        }
    }

    public void destroyCacheService() {
        this.instance.shutdown();
    }

    public void lock(String key, long seconds) {
        this.cache.lock((Object)key, seconds, TimeUnit.SECONDS);
    }

    public void unlock(String key) {
        this.cache.unlock((Object)key);
    }
}

