/*
 * Decompiled with CFR 0.152.
 */
package de.renebergelt.juitest.host;

import de.renebergelt.juitest.core.TestDescriptor;
import de.renebergelt.juitest.core.comm.IPCHandler;
import de.renebergelt.juitest.core.comm.IPCMessages;
import de.renebergelt.juitest.core.comm.messages.IPCProtocol;
import de.renebergelt.juitest.core.services.IPCTransmitter;
import de.renebergelt.juitest.core.utils.StackTraceUtils;
import de.renebergelt.juitest.host.comm.IPCServer;
import de.renebergelt.juitest.host.services.SameProcessTestRunnerService;
import de.renebergelt.juitest.host.testscripts.UIAutomationHost;
import java.util.List;

public class UITestRunner
implements IPCHandler {
    SameProcessTestRunnerService localTestRunner;
    private String host;
    private int port;

    public UITestRunner(String host, int port, UIAutomationHost automationHost, String testBasePackage) {
        this.host = host;
        this.port = port;
        this.localTestRunner = new SameProcessTestRunnerService(automationHost, testBasePackage);
    }

    public void start() {
        Thread t = new Thread(() -> {
            try {
                IPCServer server = new IPCServer(this.host, this.port, this);
                server.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        t.start();
    }

    public List<TestDescriptor> discoverTests() {
        return this.localTestRunner.discoverTests();
    }

    public void registerTransmitter(IPCTransmitter transmitter) {
        this.localTestRunner.setTransmitter(transmitter);
    }

    public IPCProtocol.IPCMessage handleMessage(IPCProtocol.IPCMessage message) {
        if (message.hasAttach()) {
            try {
                if (!this.localTestRunner.isAttached()) {
                    this.localTestRunner.attach((String[])message.getAttach().getProgramArgumentsList().toArray((Object[])new String[0]));
                }
                return IPCMessages.createSimpleResponseMessage((IPCProtocol.ResponseStatus)IPCProtocol.ResponseStatus.OK);
            }
            catch (Exception e) {
                return IPCMessages.createSimpleResponseMessage((IPCProtocol.ResponseStatus)IPCProtocol.ResponseStatus.FAILED);
            }
        }
        if (message.hasGetTests()) {
            try {
                return IPCMessages.createTestListMessage(this.discoverTests());
            }
            catch (Exception e) {
                return IPCMessages.createSimpleResponseMessage((IPCProtocol.ResponseStatus)IPCProtocol.ResponseStatus.FAILED);
            }
        }
        if (message.hasRunTest()) {
            String testId = message.getRunTest().getTestId();
            try {
                this.localTestRunner.runTest(IPCMessages.readRunTestMessage((IPCProtocol.RunTestMessage)message.getRunTest()));
                return IPCMessages.createTestStartedMessage((String)testId);
            }
            catch (Exception e) {
                return IPCMessages.createTestFailedToStartMessage((String)testId, (String)StackTraceUtils.stackTraceToString((Throwable)e));
            }
        }
        if (message.hasCancelTest()) {
            this.localTestRunner.cancelRunningTest();
            return null;
        }
        if (message.hasResumeTest()) {
            this.localTestRunner.resumeTest();
            return null;
        }
        return null;
    }
}

