/*
 * Decompiled with CFR 0.152.
 */
package de.renebergelt.juitest.host.comm;

import de.renebergelt.juitest.core.comm.IPCHandler;
import de.renebergelt.juitest.core.comm.messages.IPCProtocol;
import de.renebergelt.juitest.core.services.IPCTransmitter;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class IPCProtocolServerHandler
extends SimpleChannelInboundHandler<IPCProtocol.IPCMessage>
implements IPCTransmitter {
    ExecutorService workers = Executors.newCachedThreadPool();
    private IPCHandler messageHandler;
    private Channel activeChannel;

    public IPCProtocolServerHandler(IPCHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    protected void channelRead0(ChannelHandlerContext ctx, IPCProtocol.IPCMessage msg) throws Exception {
        this.workers.submit(() -> {
            IPCProtocol.IPCMessage response;
            if (msg.hasAttach()) {
                this.activeChannel = ctx.channel();
                this.messageHandler.registerTransmitter((IPCTransmitter)this);
            }
            if ((response = this.messageHandler.handleMessage(msg)) != null) {
                ctx.writeAndFlush((Object)response);
            }
        });
    }

    public void sendMessage(IPCProtocol.IPCMessage message) {
        if (this.activeChannel != null) {
            this.activeChannel.writeAndFlush((Object)message);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        if (ctx.channel() == this.activeChannel) {
            this.activeChannel = null;
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ctx.close();
    }
}

