/*
 * Decompiled with CFR 0.152.
 */
package de.renebergelt.juitest.host.comm;

import de.renebergelt.juitest.core.comm.IPCHandler;
import de.renebergelt.juitest.core.utils.NullGuard;
import de.renebergelt.juitest.host.comm.IPCServerChannelInitializer;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;

public class IPCServer {
    private String host;
    private int port;
    private IPCHandler messageHandler;

    public IPCServer(String host, int port, IPCHandler messageHandler) {
        this.host = (String)NullGuard.forArgument((String)"host", (Object)host);
        this.port = port;
        this.messageHandler = (IPCHandler)NullGuard.forArgument((String)"messageHandler", (Object)messageHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        NioEventLoopGroup serverGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap bootStrap = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)bootStrap.group((EventLoopGroup)serverGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new IPCServerChannelInitializer(this.messageHandler));
            ChannelFuture f = bootStrap.bind(this.host, this.port).sync();
            System.out.println("TestHost listening for connection by monitor on " + this.host + ":" + String.valueOf(this.port));
            f.channel().closeFuture().sync();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            serverGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
        }
    }
}

