/*
 * Decompiled with CFR 0.152.
 */
package de.renebergelt.juitest.host.comm;

import com.google.protobuf.MessageLite;
import de.renebergelt.juitest.core.comm.IPCHandler;
import de.renebergelt.juitest.core.comm.messages.IPCProtocol;
import de.renebergelt.juitest.host.comm.IPCProtocolServerHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.protobuf.ProtobufDecoder;
import io.netty.handler.codec.protobuf.ProtobufEncoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32FrameDecoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32LengthFieldPrepender;

public class IPCServerChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private IPCHandler messageHandler;

    public IPCServerChannelInitializer(IPCHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline p = ch.pipeline();
        p.addLast(new ChannelHandler[]{new ProtobufVarint32FrameDecoder()});
        p.addLast(new ChannelHandler[]{new ProtobufDecoder((MessageLite)IPCProtocol.IPCMessage.getDefaultInstance())});
        p.addLast(new ChannelHandler[]{new ProtobufVarint32LengthFieldPrepender()});
        p.addLast(new ChannelHandler[]{new ProtobufEncoder()});
        p.addLast(new ChannelHandler[]{new IPCProtocolServerHandler(this.messageHandler)});
    }
}

