/*
 * Decompiled with CFR 0.152.
 */
package de.renebergelt.juitest.host.services;

import de.renber.quiterables.QuIterables;
import de.renebergelt.juitest.core.TestDescriptor;
import de.renebergelt.juitest.core.annotations.UITest;
import de.renebergelt.juitest.core.annotations.UITestClass;
import de.renebergelt.juitest.core.annotations.parameterfunctions.TestDescriptionResolver;
import de.renebergelt.juitest.core.annotations.parameterfunctions.TestParameterResolver;
import de.renebergelt.juitest.core.comm.IPCMessages;
import de.renebergelt.juitest.core.comm.messages.IPCProtocol;
import de.renebergelt.juitest.core.exceptions.UITestException;
import de.renebergelt.juitest.core.services.IPCTransmitter;
import de.renebergelt.juitest.core.services.TestExecutionListener;
import de.renebergelt.juitest.core.services.TestRunnerService;
import de.renebergelt.juitest.core.services.TestStatusListener;
import de.renebergelt.juitest.core.utils.StackTraceUtils;
import de.renebergelt.juitest.host.testscripts.UIAutomationHost;
import de.renebergelt.juitest.host.testscripts.UIAutomationTest;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;
import org.reflections.Reflections;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.Scanner;

public class SameProcessTestRunnerService
implements TestRunnerService {
    IPCTransmitter transmitter;
    AtomicReference<AutomationTestThread> currentRunningTest = new AtomicReference();
    UIAutomationHost automationHost;
    String testBasePackage;

    public void setTransmitter(IPCTransmitter transmitter) {
        this.transmitter = transmitter;
        if (this.automationHost != null) {
            this.automationHost.setTransmitter(transmitter);
        }
    }

    public SameProcessTestRunnerService(UIAutomationHost host, String testBasePackage) {
        this.automationHost = host;
        this.testBasePackage = testBasePackage;
    }

    public boolean isAttached() {
        return this.automationHost != null && this.automationHost.hasLaunched();
    }

    public List<TestDescriptor> discoverTests() {
        System.out.println("Discovering tests using Reflections");
        ArrayList<TestDescriptor> descriptors = new ArrayList<TestDescriptor>();
        TestParameterResolver paramResolver = new TestParameterResolver();
        TestDescriptionResolver testDescrResolver = new TestDescriptionResolver();
        Reflections ref = new Reflections(this.testBasePackage, new Scanner[]{new MethodAnnotationsScanner()});
        Set testMethods = ref.getMethodsAnnotatedWith(UITest.class);
        for (Method m : testMethods) {
            boolean isTestClass = UIAutomationTest.class.isAssignableFrom(m.getDeclaringClass());
            if (isTestClass) {
                System.out.println(m.getDeclaringClass().getSimpleName() + "." + m.getName());
                UITest annot = m.getAnnotation(UITest.class);
                String testSetName = null;
                if (m.getDeclaringClass().isAnnotationPresent(UITestClass.class)) {
                    UITestClass tc = m.getDeclaringClass().getAnnotation(UITestClass.class);
                    testSetName = tc.testSetName();
                }
                if (paramResolver.hasParameters(m)) {
                    for (Object[] paramSet : paramResolver.resolveParameterSets(m)) {
                        TestDescriptor td = new TestDescriptor(m.getDeclaringClass().getCanonicalName(), m.getName(), paramSet);
                        if (annot.description() != null && !annot.description().isEmpty()) {
                            td.setDescription(testDescrResolver.resolve(annot.description(), paramSet));
                        }
                        if (testSetName != null && !testSetName.isEmpty()) {
                            td.setTestSetName(testSetName);
                        }
                        descriptors.add(td);
                    }
                    continue;
                }
                TestDescriptor td = new TestDescriptor(m.getDeclaringClass().getCanonicalName(), m.getName(), new Object[0]);
                if (annot.description() != null && !annot.description().isEmpty()) {
                    td.setDescription(annot.description());
                }
                if (testSetName != null && !testSetName.isEmpty()) {
                    td.setTestSetName(testSetName);
                }
                descriptors.add(td);
                continue;
            }
            System.out.println("Class " + m.getDeclaringClass().getCanonicalName() + " contains UITest methods but has not been derived from class UIAutomationTest");
        }
        return descriptors;
    }

    public void attach(String ... programArguments) {
        if (this.automationHost.hasLaunched()) {
            throw new IllegalStateException("TestRunner has already been attached");
        }
        AtomicReference result = new AtomicReference();
        this.automationHost.launchApplicationUnderTest(programArguments);
        if (!this.automationHost.hasLaunched()) {
            throw new RuntimeException("Could not launch Application under test");
        }
    }

    public void disattach() {
        if (this.isAttached()) {
            this.automationHost.teardown();
        }
    }

    public void resumeTest() {
        AutomationTestThread curTest = this.currentRunningTest.get();
        if (curTest != null) {
            curTest.resume();
        }
    }

    public void runTest(TestDescriptor testDescriptor) throws TimeoutException, CancellationException, UITestException {
        if (this.automationHost == null) {
            throw new IllegalStateException("TestRunner has not been attached");
        }
        UIAutomationTest test = this.instantiateTest(testDescriptor);
        test.setContext(this.automationHost);
        AutomationTestThread aThread = this.currentRunningTest.updateAndGet(current -> {
            if (current != null) {
                throw new IllegalStateException("Cannot start a new test when a different test is still running.");
            }
            AutomationTestThread at = AutomationTestThread.createThreadFor(this.automationHost, test, testDescriptor);
            return at;
        });
        aThread.setExecutionListener(new TestExecutionListener(){

            public void testLog(String message) {
                if (SameProcessTestRunnerService.this.transmitter != null) {
                    SameProcessTestRunnerService.this.transmitter.sendMessage(IPCMessages.createTestLogMessage((String)"", (String)message));
                }
            }

            public void testPaused(String message) {
                if (SameProcessTestRunnerService.this.transmitter != null) {
                    SameProcessTestRunnerService.this.transmitter.sendMessage(IPCMessages.createTestPausedMessage((String)"", (String)message));
                }
            }

            private void cleanup() {
                SameProcessTestRunnerService.this.currentRunningTest.set(null);
                SameProcessTestRunnerService.this.automationHost.cleanup_after_test();
            }

            public void testFailed(Throwable error) {
                this.cleanup();
                if (SameProcessTestRunnerService.this.transmitter != null) {
                    if (error instanceof TimeoutException) {
                        SameProcessTestRunnerService.this.transmitter.sendMessage(IPCMessages.createTestResultMessage((IPCProtocol.TestResult)IPCProtocol.TestResult.TIMEOUT, Optional.empty()));
                    } else if (error instanceof CancellationException) {
                        SameProcessTestRunnerService.this.transmitter.sendMessage(IPCMessages.createTestResultMessage((IPCProtocol.TestResult)IPCProtocol.TestResult.CANCELLED, Optional.empty()));
                    } else {
                        SameProcessTestRunnerService.this.transmitter.sendMessage(IPCMessages.createTestResultMessage((IPCProtocol.TestResult)IPCProtocol.TestResult.FAILURE, Optional.of(StackTraceUtils.stackTraceToString((Throwable)error))));
                    }
                }
            }

            public void testSucceeded() {
                this.cleanup();
                if (SameProcessTestRunnerService.this.transmitter != null) {
                    SameProcessTestRunnerService.this.transmitter.sendMessage(IPCMessages.createTestResultMessage((IPCProtocol.TestResult)IPCProtocol.TestResult.SUCCESS, Optional.empty()));
                }
            }
        });
        aThread.runAsync();
    }

    public void cancelRunningTest() {
        this.currentRunningTest.getAndUpdate(s -> {
            try {
                if (s != null) {
                    s.cancel();
                }
            }
            finally {
                return null;
            }
        });
    }

    private UIAutomationTest instantiateTest(TestDescriptor descriptor) throws UITestException {
        try {
            Class<?> clazz = Class.forName(descriptor.getTestClassName());
            Constructor<?> ctor = clazz.getConstructor(new Class[0]);
            UIAutomationTest instance = (UIAutomationTest)ctor.newInstance(new Object[0]);
            return instance;
        }
        catch (ClassNotFoundException e) {
            throw new UITestException("Invalid test class: " + descriptor.getTestClassName(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new UITestException("Missing parameter-less constructor: " + descriptor.getTestClassName(), (Throwable)e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new UITestException("Could not instantiate test class: " + descriptor.getTestClassName(), (Throwable)e);
        }
    }

    public void addTestStatusListener(TestStatusListener testStatusListener) {
    }

    public void removeTestStatusListener(TestStatusListener testStatusListener) {
    }

    static class AutomationTestThread {
        private Thread thread;
        private UIAutomationTest test;
        private TestDescriptor testDescriptor;
        private Runnable threadBody;
        private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
        private AtomicReference<Throwable> failException = new AtomicReference<Object>(null);
        AtomicReference<Thread.UncaughtExceptionHandler> oldUncaughtExceptionHandler;
        TestExecutionListener executionListener;

        public void setExecutionListener(TestExecutionListener executionListener) {
            this.executionListener = executionListener;
            this.test.setExecutionListener(executionListener);
        }

        private AutomationTestThread(UIAutomationHost context, UIAutomationTest test, TestDescriptor testDescriptor) {
            this.test = test;
            this.testDescriptor = testDescriptor;
            this.threadBody = () -> {
                this.failException.set(null);
                try {
                    Object[] methods = test.getClass().getMethods();
                    List availableMethods = QuIterables.query((Object[])methods).where(x -> testDescriptor.getTestMethodName().equals(x.getName()) && x.isAnnotationPresent(UITest.class)).toList();
                    if (availableMethods.size() == 0) {
                        throw new RuntimeException("UiTest method " + test.getClass().getCanonicalName() + "." + testDescriptor.getTestMethodName() + " does not exist");
                    }
                    Method method = null;
                    for (Method m : availableMethods) {
                        UITest annot = m.getAnnotation(UITest.class);
                        TestParameterResolver resolver = new TestParameterResolver();
                        List paramNames = resolver.getDeclaredParameterNames(m);
                        if (paramNames.size() != testDescriptor.getParameters().length / 2) continue;
                        boolean namesMatch = true;
                        for (int nameIdx = 0; nameIdx < paramNames.size(); ++nameIdx) {
                            if (((String)paramNames.get(nameIdx)).equals(testDescriptor.getParameters()[nameIdx * 2])) continue;
                            namesMatch = false;
                            break;
                        }
                        if (!namesMatch) continue;
                        method = m;
                        break;
                    }
                    if (method == null) {
                        throw new RuntimeException("UiTest method " + test.getClass().getCanonicalName() + "." + testDescriptor.getTestMethodName() + " is missing parameters");
                    }
                    try {
                        test.beforeTest();
                        if (method.getParameterCount() == 0) {
                            method.invoke((Object)test, new Object[0]);
                        } else {
                            Object[] paramValues = new Object[testDescriptor.getParameters().length / 2];
                            for (int i = 0; i < paramValues.length; ++i) {
                                paramValues[i] = testDescriptor.getParameters()[i * 2 + 1];
                            }
                            method.invoke((Object)test, paramValues);
                        }
                    }
                    finally {
                        test.afterTest();
                    }
                }
                catch (Exception e) {
                    this.failException.getAndUpdate(v -> {
                        if (v == null) {
                            return e;
                        }
                        return v;
                    });
                }
                catch (Error e) {
                    this.failException.getAndUpdate(v -> {
                        if (v == null) {
                            return e;
                        }
                        return v;
                    });
                }
                finally {
                    this.testEnded();
                }
            };
            this.uncaughtExceptionHandler = (t, e) -> {
                this.failException.getAndUpdate(v -> {
                    if (v == null) {
                        return e;
                    }
                    return v;
                });
                this.thread.interrupt();
            };
            this.thread = new Thread(this.threadBody);
        }

        private void runAsync() throws TimeoutException, UITestException, CancellationException {
            this.oldUncaughtExceptionHandler = new AtomicReference();
            try {
                SwingUtilities.invokeAndWait(() -> {
                    this.oldUncaughtExceptionHandler.set(Thread.getDefaultUncaughtExceptionHandler());
                    Thread.setDefaultUncaughtExceptionHandler(this.uncaughtExceptionHandler);
                });
            }
            catch (Exception e) {
                System.out.println("Could not set UncaughtExceptionHandler");
            }
            this.thread.start();
        }

        private void testEnded() {
            try {
                SwingUtilities.invokeAndWait(() -> Thread.setDefaultUncaughtExceptionHandler(this.oldUncaughtExceptionHandler.get()));
            }
            catch (Exception e) {
                System.out.println("Could not reset UncaughtExceptionHandler");
            }
            Throwable t = this.failException.get();
            if (t == null) {
                this.executionListener.testSucceeded();
            } else {
                this.executionListener.testFailed(this.unnpackException(t));
            }
        }

        private Throwable unnpackException(Throwable t) {
            if (t == null) {
                return null;
            }
            if (t instanceof InvocationTargetException && t.getCause() != null) {
                t = t.getCause();
            }
            return t;
        }

        public void resume() {
            this.test.resume();
        }

        public void cancel() {
            this.failException.set(new CancellationException());
            this.thread.interrupt();
        }

        public static AutomationTestThread createThreadFor(UIAutomationHost context, UIAutomationTest test, TestDescriptor testDescriptor) {
            return new AutomationTestThread(context, test, testDescriptor);
        }
    }
}

