/*
 * Decompiled with CFR 0.152.
 */
package de.renebergelt.juitest.host.testscripts;

import de.renber.quiterables.QuIterables;
import de.renebergelt.juitest.core.AutoResetEvent;
import de.renebergelt.juitest.core.Timeout;
import de.renebergelt.juitest.core.exceptions.AutomationException;
import de.renebergelt.juitest.host.testscripts.UIAutomationHost;
import de.renebergelt.juitest.host.testscripts.UIAutomationTest;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public abstract class SwingAutomationTest<THost extends UIAutomationHost>
extends UIAutomationTest<THost> {
    public void uiActionWait(Runnable step) throws CancellationException {
        try {
            this.uiActionWait(Timeout.NONE, step);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public void uiActionWait(Timeout timeout, Runnable step) throws CancellationException, TimeoutException {
        this.uiActionWait(timeout, () -> {
            step.run();
            return true;
        });
    }

    public <T> T uiActionWait(Supplier<T> step) throws CancellationException {
        try {
            return this.uiActionWait(Timeout.NONE, step);
        }
        catch (TimeoutException e) {
            return null;
        }
    }

    public <T> T uiActionWait(Timeout timeout, Supplier<T> step) throws CancellationException, TimeoutException {
        if (this.cancellationRequested) {
            throw new CancellationException();
        }
        AutoResetEvent evt = new AutoResetEvent(false);
        try {
            AtomicReference rval = new AtomicReference();
            SwingUtilities.invokeLater(() -> {
                rval.set(step.get());
                evt.set();
            });
            this.currentEvent.set(evt);
            if (timeout == Timeout.NONE) {
                timeout = DEFAULT_TIMEOUT;
            }
            if (!evt.waitOne(timeout.getMilliseconds())) {
                throw new TimeoutException();
            }
            if (this.cancellationRequested) {
                throw new CancellationException();
            }
            return (T)rval.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("UI action failed: " + e.getMessage(), e);
        }
    }

    public void uiActionAsync(Runnable step) throws CancellationException {
        if (this.cancellationRequested) {
            throw new CancellationException();
        }
        SwingUtilities.invokeLater(step);
    }

    public void waitForCondition(Timeout timeout, Supplier<Boolean> condition) throws TimeoutException {
        this.log("WAIT FOR CONDITION");
        long t = System.currentTimeMillis();
        while (!condition.get().booleanValue()) {
            if (this.cancellationRequested) {
                throw new CancellationException();
            }
            if (timeout != Timeout.NONE && System.currentTimeMillis() - t >= timeout.getMilliseconds()) {
                throw new TimeoutException();
            }
            this.wait(Timeout.milliseconds((long)500L));
        }
    }

    public <T extends Window> T expectWindow(Timeout timeout, Runnable winOpenAction, Class<T> windowClass) throws TimeoutException {
        this.uiActionAsync(winOpenAction);
        return this.waitForWindow(timeout, windowClass);
    }

    public <T extends Window> T waitForWindow(Timeout timeout, Class<T> windowClass) throws TimeoutException {
        this.log("WAIT FOR WINDOW " + windowClass.toString());
        return this.waitForWindow_internal(timeout, w -> windowClass.equals(w.getClass()));
    }

    public void waitUntilWindowIsClosed(Timeout timeout, Window window) throws TimeoutException {
        long t = System.currentTimeMillis();
        while (window.isShowing()) {
            if (timeout != Timeout.NONE && System.currentTimeMillis() - t >= timeout.getMilliseconds()) {
                throw new TimeoutException();
            }
            this.wait(Timeout.milliseconds((long)500L));
        }
        this.wait(Timeout.milliseconds((long)900L));
    }

    public <T extends Window> T waitForWindow(Timeout timeout, Predicate<Window> condition) throws TimeoutException {
        this.log("WAIT FOR WINDOW BY CONDITION");
        return this.waitForWindow_internal(timeout, condition);
    }

    public <T extends Window> T waitForWindow_internal(Timeout timeout, Predicate<Window> condition) throws TimeoutException {
        if (timeout == Timeout.NONE) {
            timeout = DEFAULT_TIMEOUT;
        }
        long t = System.currentTimeMillis();
        while (true) {
            if (this.cancellationRequested) {
                throw new CancellationException();
            }
            if (System.currentTimeMillis() - t >= timeout.getMilliseconds()) {
                throw new TimeoutException();
            }
            Object[] windows = Window.getWindows();
            Window w = (Window)QuIterables.query((Object[])windows).firstOrDefault(x -> x.isVisible() && condition.test((Window)x));
            if (w != null) {
                while (!w.isShowing()) {
                    this.wait(Timeout.seconds((double)2.0));
                }
                return (T)w;
            }
            this.wait(Timeout.milliseconds((long)500L));
        }
    }

    public void waitForAndDimissOptionPane(Timeout timeout, Object result) throws TimeoutException {
        this.log("WAIT FOR OPTIONPANE");
        Object dialog = this.waitForWindow(timeout, (Window w) -> w instanceof JDialog && ((JDialog)w).getContentPane().getComponentCount() > 0 && ((JDialog)w).getContentPane().getComponent(0) instanceof JOptionPane);
        JOptionPane p = (JOptionPane)((JDialog)dialog).getContentPane().getComponent(0);
        this.uiActionWait(() -> {
            if (p.getWantsInput()) {
                p.setInputValue(result);
            } else {
                p.setValue(result);
            }
            dialog.setVisible(false);
        });
    }

    public void wait(Timeout timeout) {
        if (timeout.getMilliseconds() >= 1000L) {
            this.log("WAIT FOR " + (double)timeout.getMilliseconds() / 1000.0 + "s");
        }
        AutoResetEvent evt = new AutoResetEvent(false);
        try {
            this.currentEvent.set(evt);
            evt.waitOne(timeout.getMilliseconds());
        }
        catch (InterruptedException e) {
            throw new AutomationException(e.getMessage(), (Throwable)e);
        }
    }

    public static <T extends Component> T findComponent(Container parent, Class<T> componentClass) {
        return (T)SwingAutomationTest.findComponent(parent, componentClass, c -> true);
    }

    public static <T extends Component> T findComponent(Container parent, Class<T> componentClass, Predicate<T> condition) {
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            T cc;
            Component c = parent.getComponent(i);
            if (componentClass.isInstance(c) && condition.test(c)) {
                return (T)c;
            }
            if (!(c instanceof Container) || (cc = SwingAutomationTest.findComponent((Container)c, componentClass, condition)) == null) continue;
            return cc;
        }
        return null;
    }
}

