/*
 * Decompiled with CFR 0.152.
 */
package de.renebergelt.juitest.host.testscripts;

import de.renebergelt.juitest.core.AutoResetEvent;
import de.renebergelt.juitest.core.Timeout;
import de.renebergelt.juitest.core.exceptions.AutomationException;
import de.renebergelt.juitest.core.services.TestExecutionListener;
import de.renebergelt.juitest.host.testscripts.UIAutomationHost;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public abstract class UIAutomationTest<THost extends UIAutomationHost> {
    public static final Timeout DEFAULT_TIMEOUT = Timeout.minutes((double)1.0);
    protected boolean cancellationRequested;
    TestExecutionListener executionListener;
    protected THost context;
    protected AtomicReference<AutoResetEvent> currentEvent = new AtomicReference();

    public void setContext(THost context) {
        this.context = context;
    }

    public void setExecutionListener(TestExecutionListener executionListener) {
        this.executionListener = executionListener;
    }

    public void resume() {
        this.currentEvent.getAndUpdate(evt -> {
            if (evt != null) {
                evt.set();
            }
            return null;
        });
    }

    public void pause(String message) {
        if (this.executionListener == null) {
            return;
        }
        AutoResetEvent evt = new AutoResetEvent(false);
        this.currentEvent.set(evt);
        try {
            this.executionListener.testPaused(message);
            evt.waitOne();
        }
        catch (InterruptedException e) {
            throw new CancellationException();
        }
        if (this.cancellationRequested) {
            throw new CancellationException();
        }
    }

    public void cancel() {
        this.cancellationRequested = true;
        Thread cancelThread = new Thread(() -> {
            AutoResetEvent evt = this.currentEvent.get();
            if (evt != null) {
                evt.cancel();
            }
        });
        cancelThread.start();
    }

    public void log(String message) {
        if (this.executionListener == null) {
            return;
        }
        this.executionListener.testLog(message);
    }

    public void scriptAssert(Supplier<Boolean> condition) throws AutomationException {
        if (!condition.get().booleanValue()) {
            throw new AutomationException("Condition not satisfied");
        }
    }

    public void scriptAssert(Supplier<Boolean> condition, String failureMessage) throws AutomationException {
        if (!condition.get().booleanValue()) {
            throw new AutomationException("Condition not satisfied: " + failureMessage);
        }
    }

    public void beforeTest() {
    }

    public void afterTest() {
    }
}

