/*
 * Decompiled with CFR 0.152.
 */
package de.renebergelt.maven.plugins;

import de.renebergelt.maven.plugins.compileswitches.Switch;
import de.renebergelt.maven.plugins.compileswitches.SwitchesFile;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class CompileSwitchesMojo
extends AbstractMojo {
    @Parameter(property="switches")
    public List<Switch> switches;
    @Parameter(readonly=true, defaultValue="${project}")
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        this.log("CompileSwitchesMojo Copyright (c) 2018 by Ren\u00e9 Bergelt, TU Chemnitz");
        this.checkParams();
        if (this.switches == null || this.switches.size() == 0) {
            this.warn("No compile switches have been defined. Skipping code-generation");
        } else {
            for (Switch sw : this.switches) {
                SwitchesFile genFile = new SwitchesFile(sw.getPackageName(), sw.getClassName(), sw.fields);
                String targetDir = this.project.getBuild().getDirectory() + "/generated-sources/compile-switches/";
                if (!new File(targetDir = targetDir + sw.getPackageName().replace(".", "/")).exists() && !new File(targetDir).mkdirs()) {
                    throw new MojoExecutionException("Could not create target directory for code generation: " + targetDir);
                }
                try {
                    genFile.save(targetDir + "/" + sw.getClassName() + ".java");
                    this.project.addCompileSourceRoot(targetDir);
                }
                catch (IOException e) {
                    throw new MojoExecutionException(e.getMessage());
                }
            }
        }
    }

    private void log(String message) {
        this.getLog().info((CharSequence)message);
    }

    private void warn(String message) {
        this.getLog().warn((CharSequence)message);
    }

    private void error(String message) {
        this.getLog().error((CharSequence)message);
    }

    void checkParams() throws MojoExecutionException {
    }
}

