/*
 * Decompiled with CFR 0.152.
 */
package de.renebergelt.maven.plugins.compileswitches;

import de.renebergelt.maven.plugins.compileswitches.Field;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SwitchesFile {
    List<Field> fields = new ArrayList<Field>();
    private String packageName;
    private String className;
    private String nl = System.lineSeparator();

    public SwitchesFile(String packageName, String className, List<Field> fields) {
        this.packageName = packageName;
        this.className = className;
        this.fields = fields;
    }

    public void save(String filename) throws IOException {
        try (FileWriter writer = new FileWriter(filename);){
            writer.write("package " + this.packageName + ";" + this.nl);
            writer.write(this.nl);
            writer.write("/**" + this.nl);
            writer.write(" * generated by compile-switches-maven-plugin" + this.nl);
            writer.write(" */" + this.nl);
            writer.write("public class " + this.className + "{" + this.nl);
            writer.write(this.nl);
            this.writeFields(writer);
            writer.write(this.nl);
            this.writePrivateConstructor(writer);
            writer.write(this.nl);
            writer.write("}");
        }
    }

    private void writeFields(FileWriter writer) throws IOException {
        for (Field f : this.fields) {
            writer.write("public static final boolean " + f.fieldName + " = " + String.valueOf(f.fieldValue) + ";" + this.nl);
        }
    }

    private void writePrivateConstructor(FileWriter writer) throws IOException {
        writer.write("private " + this.className + "() {}" + this.nl);
    }
}

