/*
 * Decompiled with CFR 0.152.
 */
package de.renebergelt.quiterables;

import de.renebergelt.quiterables.Equivalence;
import de.renebergelt.quiterables.GroupImpl;
import de.renebergelt.quiterables.GroupedListImpl;
import de.renebergelt.quiterables.GroupedQueriableImpl;
import de.renebergelt.quiterables.ItemFunc;
import de.renebergelt.quiterables.NumberFunc;
import de.renebergelt.quiterables.OrderedQueriable;
import de.renebergelt.quiterables.OrderedQueriableImpl;
import de.renebergelt.quiterables.Predicate;
import de.renebergelt.quiterables.PrimitiveArrayTransformer;
import de.renebergelt.quiterables.PrimitiveArrayTransformerImpl;
import de.renebergelt.quiterables.Queriable;
import de.renebergelt.quiterables.Query;
import de.renebergelt.quiterables.Selector;
import de.renebergelt.quiterables.SortOrder;
import de.renebergelt.quiterables.grouping.GroupFunction;
import de.renebergelt.quiterables.grouping.GroupKey;
import de.renebergelt.quiterables.grouping.GroupedQueriable;
import de.renebergelt.quiterables.grouping.SingleKeyGroupFunction;
import de.renebergelt.quiterables.iterators.LazyConcatIterable;
import de.renebergelt.quiterables.iterators.LazyDistinctIterable;
import de.renebergelt.quiterables.iterators.LazySelectIterable;
import de.renebergelt.quiterables.iterators.LazySelectManyIterable;
import de.renebergelt.quiterables.iterators.LazySkipIterable;
import de.renebergelt.quiterables.iterators.LazyTakeIterable;
import de.renebergelt.quiterables.iterators.LazyWhereIterable;
import de.renebergelt.quiterables.iterators.ListReverseIterable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;

class QueriableImpl<T>
implements Queriable<T> {
    protected Iterable<T> containedIter;

    protected QueriableImpl(Iterable<T> forIterable) {
        if (forIterable == null) {
            throw new IllegalArgumentException("forIterable must not be null");
        }
        this.containedIter = forIterable;
    }

    protected void throwIfArgumentIsNull(Object ... arguments) throws IllegalArgumentException {
        for (Object argument : arguments) {
            if (argument != null) continue;
            throw new IllegalArgumentException("Argument must not be null.");
        }
    }

    private <TIn> TIn throwIfNull(TIn element) throws NoSuchElementException {
        if (element == null) {
            throw new NoSuchElementException();
        }
        return element;
    }

    @Override
    public List<T> toList() {
        ArrayList<T> list = new ArrayList<T>();
        for (T element : this.containedIter) {
            list.add(element);
        }
        return list;
    }

    @Override
    public <TKey, TValue> Map<TKey, TValue> toMap(Function<T, TKey> keyFunc, Function<T, TValue> valueFunc) {
        HashMap<TKey, TValue> map = new HashMap<TKey, TValue>();
        for (T element : this.containedIter) {
            map.put(keyFunc.apply(element), valueFunc.apply(element));
        }
        return map;
    }

    @Override
    public <TKey> Map<TKey, T> toMap(Function<T, TKey> keyFunc) {
        return this.toMap(keyFunc, e -> e);
    }

    @Override
    public Set<T> toSet() {
        HashSet set = new HashSet();
        for (Object element : this.distinct()) {
            set.add(element);
        }
        return set;
    }

    @Override
    public T[] toArray(Class<T> classType) {
        this.throwIfArgumentIsNull(classType);
        Object[] a = (Object[])Array.newInstance(classType, this.count());
        int idx = 0;
        for (T element : this.containedIter) {
            a[idx] = element;
            ++idx;
        }
        return a;
    }

    @Override
    public PrimitiveArrayTransformer<T> toPrimitiveArray() {
        return new PrimitiveArrayTransformerImpl<T>(this.containedIter);
    }

    @Override
    public boolean isEmpty() {
        return !this.containedIter.iterator().hasNext();
    }

    @Override
    public Queriable<T> defaultIfEmpty(T defaultValue) {
        if (this.isEmpty()) {
            ArrayList<T> list = new ArrayList<T>();
            list.add(defaultValue);
            return Query.list(list);
        }
        return this;
    }

    @Override
    public T elementAt(int index) throws NoSuchElementException {
        return this.throwIfNull(this.elementAtOrDefault(index));
    }

    @Override
    public T elementAtOrDefault(int index) {
        if (this.containedIter instanceof List) {
            List innerList = (List)this.containedIter;
            if (index < innerList.size()) {
                return (T)innerList.get(index);
            }
            return null;
        }
        Iterator<T> it = this.containedIter.iterator();
        for (int i = 0; i < index; ++i) {
            if (!it.hasNext()) {
                return null;
            }
            it.next();
        }
        return it.hasNext() ? (T)it.next() : null;
    }

    @Override
    public T elementAtOrDefault(int index, T defaultValue) {
        this.throwIfArgumentIsNull(defaultValue);
        T element = this.elementAtOrDefault(index);
        return element == null ? defaultValue : element;
    }

    @Override
    public Queriable<T> where(Predicate<T> predicate) {
        this.throwIfArgumentIsNull(predicate);
        return Query.iterable(new LazyWhereIterable<T>(this.containedIter, predicate));
    }

    @Override
    public boolean sequenceEquals(Iterable<T> iterable) {
        this.throwIfArgumentIsNull(iterable);
        Iterator<T> it1 = this.iterator();
        Iterator<T> it2 = iterable.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            T item2;
            T item1 = it1.next();
            if (item1.equals(item2 = it2.next())) continue;
            return false;
        }
        return !it1.hasNext() && !it2.hasNext();
    }

    @Override
    public boolean sequenceEquals(Iterable<T> iterable, Equivalence<T> equalityComparer) {
        this.throwIfArgumentIsNull(iterable, equalityComparer);
        Iterator<T> it1 = this.iterator();
        Iterator<T> it2 = iterable.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            T item2;
            T item1 = it1.next();
            if (equalityComparer.areEqual(item1, item2 = it2.next())) continue;
            return false;
        }
        return !it1.hasNext() && !it2.hasNext();
    }

    @Override
    public boolean all(Predicate<T> predicate) {
        this.throwIfArgumentIsNull(predicate);
        for (T item : this.containedIter) {
            if (predicate.evaluate(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean exists(Predicate<T> predicate) {
        this.throwIfArgumentIsNull(predicate);
        for (T item : this.containedIter) {
            if (!predicate.evaluate(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(T element) {
        this.throwIfArgumentIsNull(element);
        for (T item : this) {
            if (!item.equals(element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(T element, Equivalence<T> equalityComparer) {
        this.throwIfArgumentIsNull(element, equalityComparer);
        for (T item : this) {
            if (!equalityComparer.areEqual(element, item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public T first() throws NoSuchElementException {
        return this.throwIfNull(this.firstOrDefault());
    }

    @Override
    public T firstOrDefault() {
        return this.firstOrDefault((T)null);
    }

    @Override
    public T firstOrDefault(T defaultValue) {
        Iterator<T> it = this.containedIter.iterator();
        return it.hasNext() ? it.next() : defaultValue;
    }

    @Override
    public T first(Predicate<T> predicate) throws NoSuchElementException {
        this.throwIfArgumentIsNull(predicate);
        return this.throwIfNull(this.firstOrDefault(predicate));
    }

    @Override
    public T firstOrDefault(Predicate<T> predicate) {
        this.throwIfArgumentIsNull(predicate);
        for (T item : this.containedIter) {
            if (!predicate.evaluate(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public T firstOrDefault(Predicate<T> predicate, T defaultValue) {
        this.throwIfArgumentIsNull(predicate, defaultValue);
        T element = this.firstOrDefault(predicate);
        return element == null ? defaultValue : element;
    }

    @Override
    public T last() throws NoSuchElementException {
        return this.throwIfNull(this.lastOrDefault());
    }

    @Override
    public T lastOrDefault() {
        Iterator<T> it = this.containedIter.iterator();
        T lastElement = null;
        while (it.hasNext()) {
            lastElement = it.next();
        }
        return lastElement;
    }

    @Override
    public T last(Predicate<T> predicate) throws NoSuchElementException {
        this.throwIfArgumentIsNull(predicate);
        return this.throwIfNull(this.lastOrDefault(predicate));
    }

    @Override
    public T lastOrDefault(Predicate<T> predicate) {
        this.throwIfArgumentIsNull(predicate);
        return Query.iterable(this.containedIter).where(predicate).lastOrDefault();
    }

    @Override
    public T lastOrDefault(Predicate<T> predicate, T defaultValue) {
        this.throwIfArgumentIsNull(predicate, defaultValue);
        T element = this.lastOrDefault(predicate);
        return element == null ? defaultValue : element;
    }

    @Override
    public T single() throws NoSuchElementException {
        return this.throwIfNull(this.singleOrDefault());
    }

    @Override
    public T singleOrDefault() {
        Iterator<T> it = this.containedIter.iterator();
        if (!it.hasNext()) {
            return null;
        }
        T element = it.next();
        if (it.hasNext()) {
            return null;
        }
        return element;
    }

    @Override
    public T single(Predicate<T> predicate) throws NoSuchElementException {
        this.throwIfArgumentIsNull(predicate);
        return this.throwIfNull(this.singleOrDefault(predicate));
    }

    @Override
    public T singleOrDefault(Predicate<T> predicate) {
        this.throwIfArgumentIsNull(predicate);
        return Query.iterable(this.containedIter).where(predicate).singleOrDefault();
    }

    @Override
    public int count() {
        if (this.containedIter instanceof Collection) {
            return ((Collection)this.containedIter).size();
        }
        int c = 0;
        Iterator<T> it = this.containedIter.iterator();
        while (it.hasNext()) {
            ++c;
            it.next();
        }
        return c;
    }

    @Override
    public int count(Predicate<T> predicate) {
        this.throwIfArgumentIsNull(predicate);
        int c = 0;
        for (T element : this.containedIter) {
            if (!predicate.evaluate(element)) continue;
            ++c;
        }
        return c;
    }

    @Override
    public T max() {
        if (this.isEmpty()) {
            throw new IllegalStateException("The iteration has no elements.");
        }
        T max = null;
        for (T item : this.containedIter) {
            if (!(item instanceof Comparable)) {
                throw new RuntimeException("The value for the list element '" + item.toString() + "' does not implement the Comparable interface.");
            }
            if (max != null && ((Comparable)item).compareTo((Comparable)max) != 1) continue;
            max = item;
        }
        return max;
    }

    @Override
    public Number max(NumberFunc<T> valFunc) {
        this.throwIfArgumentIsNull(valFunc);
        if (this.isEmpty()) {
            throw new IllegalStateException("The iteration has no elements.");
        }
        Number max = null;
        for (T item : this.containedIter) {
            Number c = valFunc.getValue(item);
            if (!(c instanceof Comparable)) {
                throw new RuntimeException("The numerical value for the list element '" + item.toString() + "' does not implement the Comparable interface.");
            }
            if (max != null && ((Comparable)((Object)c)).compareTo((Comparable)((Object)max)) != 1) continue;
            max = c;
        }
        return max;
    }

    @Override
    public T min() {
        if (this.isEmpty()) {
            throw new IllegalStateException("The iteration has no elements.");
        }
        T min = null;
        for (T item : this.containedIter) {
            if (!(item instanceof Comparable)) {
                throw new RuntimeException("The value for the list element '" + item.toString() + "' does not implement the Comparable interface.");
            }
            if (min != null && ((Comparable)item).compareTo((Comparable)min) != -1) continue;
            min = item;
        }
        return min;
    }

    @Override
    public Number min(NumberFunc<T> valFunc) {
        this.throwIfArgumentIsNull(valFunc);
        if (this.isEmpty()) {
            throw new IllegalStateException("The iteration has no elements.");
        }
        Number min = null;
        for (T item : this.containedIter) {
            Number c = valFunc.getValue(item);
            if (!(c instanceof Comparable)) {
                throw new RuntimeException("The numerical value for the list element '" + item.toString() + "' does not implement the Comparable interface.");
            }
            if (min != null && ((Comparable)((Object)c)).compareTo((Comparable)((Object)min)) != -1) continue;
            min = c;
        }
        return min;
    }

    @Override
    public Number average() {
        return this.average(new SimpleCastNumberFunc());
    }

    @Override
    public Number average(NumberFunc<T> valFunc) {
        this.throwIfArgumentIsNull(valFunc);
        if (this.isEmpty()) {
            throw new IllegalStateException("The iteration has no elements.");
        }
        Double avg = null;
        int count = 0;
        for (T item : this.containedIter) {
            Number c = valFunc.getValue(item);
            avg = avg == null ? Double.valueOf(c.doubleValue()) : Double.valueOf((avg * (double)count + c.doubleValue()) / (double)(count + 1));
            ++count;
        }
        return avg;
    }

    @Override
    public Number sum() {
        return this.sum(new SimpleCastNumberFunc());
    }

    @Override
    public Number sum(NumberFunc<T> valFunc) {
        this.throwIfArgumentIsNull(valFunc);
        Number sum = null;
        for (T item : this.containedIter) {
            Number c = valFunc.getValue(item);
            if (sum == null) {
                sum = c;
                continue;
            }
            if (c instanceof Integer) {
                sum = (Integer)sum + (Integer)c;
                continue;
            }
            if (c instanceof Double) {
                sum = (Double)sum + (Double)c;
                continue;
            }
            sum = sum.doubleValue() + c.doubleValue();
        }
        return sum == null ? (Number)0 : (Number)sum;
    }

    @Override
    public <TOut> Queriable<TOut> select(Selector<T, TOut> selector) {
        this.throwIfArgumentIsNull(selector);
        return new QueriableImpl<T>(new LazySelectIterable<T, TOut>(this.containedIter, selector));
    }

    @Override
    public <TOut> Queriable<TOut> selectMany(Selector<T, Iterable<TOut>> selector) {
        this.throwIfArgumentIsNull(selector);
        return new QueriableImpl<T>(new LazySelectManyIterable<T, TOut>(this.containedIter, selector));
    }

    @Override
    public <TOut> Queriable<TOut> cast(Class<TOut> targetType) {
        this.throwIfArgumentIsNull(targetType);
        return Query.iterable(new LazySelectIterable(this.containedIter, new Selector<T, TOut>(){

            @Override
            public TOut select(T item) {
                return item;
            }
        }));
    }

    @Override
    public <TOut> Queriable<TOut> ofType(final Class<TOut> targetType) {
        this.throwIfArgumentIsNull(targetType);
        return Query.iterable(this.where(new Predicate<T>(){

            @Override
            public boolean evaluate(T item) {
                return item != null && targetType.isAssignableFrom(item.getClass());
            }
        }).cast(targetType));
    }

    @Override
    public Queriable<T> concat(Iterable<T> toConcat) {
        this.throwIfArgumentIsNull(toConcat);
        return Query.iterable(new LazyConcatIterable<T>(this.containedIter, toConcat));
    }

    @Override
    public Queriable<T> union(Iterable<T> toConcat) {
        this.throwIfArgumentIsNull(toConcat);
        return Query.iterable(new LazyConcatIterable<T>(this.containedIter, toConcat)).distinct();
    }

    @Override
    public Queriable<T> union(Iterable<T> toConcat, Equivalence<T> equalityComparer) {
        this.throwIfArgumentIsNull(toConcat, equalityComparer);
        return Query.iterable(new LazyConcatIterable<T>(this.containedIter, toConcat)).distinct(equalityComparer);
    }

    @Override
    public Queriable<T> intersect(Iterable<T> intersectWith) {
        this.throwIfArgumentIsNull(intersectWith);
        List<T> intersectList = Query.iterable(intersectWith).toList();
        ArrayList<T> resultList = new ArrayList<T>();
        for (T element : this) {
            if (!intersectList.contains(element)) continue;
            resultList.add(element);
        }
        return Query.list(resultList);
    }

    @Override
    public Queriable<T> intersect(Iterable<T> intersectWith, final Equivalence<T> equalityComparer) {
        this.throwIfArgumentIsNull(intersectWith, equalityComparer);
        Queriable<T> intersectQueriable = Query.iterable(intersectWith);
        ArrayList<T> resultList = new ArrayList<T>();
        for (final T element : this) {
            if (!intersectQueriable.exists(new Predicate<T>(){

                @Override
                public boolean evaluate(T item) {
                    return equalityComparer.areEqual(element, item);
                }
            })) continue;
            resultList.add(element);
        }
        return Query.list(resultList);
    }

    @Override
    public Queriable<T> except(Iterable<T> elementsToSubtract) {
        this.throwIfArgumentIsNull(elementsToSubtract);
        List<T> intersectList = Query.iterable(elementsToSubtract).toList();
        ArrayList<T> resultList = new ArrayList<T>();
        for (T element : this) {
            if (intersectList.contains(element)) continue;
            resultList.add(element);
        }
        return Query.list(resultList);
    }

    @Override
    public Queriable<T> except(Iterable<T> elementsToSubtract, final Equivalence<T> equalityComparer) {
        this.throwIfArgumentIsNull(elementsToSubtract, equalityComparer);
        Queriable<T> intersectQueriable = Query.iterable(elementsToSubtract);
        ArrayList<T> resultList = new ArrayList<T>();
        for (final T element : this) {
            if (intersectQueriable.exists(new Predicate<T>(){

                @Override
                public boolean evaluate(T item) {
                    return equalityComparer.areEqual(element, item);
                }
            })) continue;
            resultList.add(element);
        }
        return Query.list(resultList);
    }

    @Override
    public Queriable<T> distinct() {
        return Query.iterable(new LazyDistinctIterable<T>(this.containedIter));
    }

    @Override
    public Queriable<T> distinct(Equivalence<T> equalityComparer) {
        this.throwIfArgumentIsNull(equalityComparer);
        return Query.iterable(new LazyDistinctIterable<T>(this.containedIter, equalityComparer));
    }

    @Override
    public Queriable<T> take(int amount) {
        return Query.iterable(new LazyTakeIterable<T>(this.containedIter, amount));
    }

    @Override
    public Queriable<T> takeWhile(Predicate<T> condition) {
        this.throwIfArgumentIsNull(condition);
        return Query.iterable(new LazyTakeIterable<T>(this.containedIter, condition));
    }

    @Override
    public Queriable<T> skip(int amount) {
        return Query.iterable(new LazySkipIterable<T>(this.containedIter, amount));
    }

    @Override
    public Queriable<T> skipWhile(Predicate<T> condition) {
        this.throwIfArgumentIsNull(condition);
        return Query.iterable(new LazySkipIterable<T>(this.containedIter, condition));
    }

    @Override
    public OrderedQueriable<T> orderBy(ItemFunc<T, Comparable> func) {
        this.throwIfArgumentIsNull(func);
        return new OrderedQueriableImpl<T>(this.containedIter, func, SortOrder.Ascending);
    }

    @Override
    public <TComparable> OrderedQueriable<T> orderBy(ItemFunc<T, TComparable> valueFunc, Comparator<TComparable> comparator) {
        this.throwIfArgumentIsNull(comparator);
        return new OrderedQueriableImpl<T>(this.containedIter, valueFunc, comparator, SortOrder.Ascending);
    }

    @Override
    public OrderedQueriable<T> orderByDescending(ItemFunc<T, Comparable> func) {
        this.throwIfArgumentIsNull(func);
        return new OrderedQueriableImpl<T>(this.containedIter, func, SortOrder.Descending);
    }

    @Override
    public <TComparable> OrderedQueriable<T> orderByDescending(ItemFunc<T, TComparable> valueFunc, Comparator<TComparable> comparator) {
        this.throwIfArgumentIsNull(comparator);
        return new OrderedQueriableImpl<T>(this.containedIter, valueFunc, comparator, SortOrder.Descending);
    }

    @Override
    public Queriable<T> reverse() {
        if (this.containedIter instanceof List) {
            return Query.iterable(new ListReverseIterable((List)this.containedIter));
        }
        List<T> lst = this.toList();
        Collections.reverse(lst);
        return Query.iterable(lst);
    }

    @Override
    public GroupedQueriable<T> group(GroupFunction<T> func) {
        this.throwIfArgumentIsNull(func);
        HashMap groups = new HashMap();
        for (T element : this.containedIter) {
            GroupKey gk = func.getKeyFor(element);
            GroupImpl els = (GroupImpl)groups.get(gk);
            if (els == null) {
                els = new GroupImpl(gk);
                groups.put(gk, els);
            }
            els.add(element);
        }
        GroupedListImpl gList = new GroupedListImpl();
        gList.addAll(groups.values());
        return new GroupedQueriableImpl(gList);
    }

    @Override
    public GroupedQueriable<T> groupSingle(final SingleKeyGroupFunction<T> func) {
        this.throwIfArgumentIsNull(func);
        return this.group(new GroupFunction<T>(){

            @Override
            public GroupKey getKeyFor(T element) {
                return new GroupKey(func.getKeyElementFor(element));
            }
        });
    }

    @Override
    public Iterator<T> iterator() {
        return this.containedIter.iterator();
    }

    class SimpleCastNumberFunc<TNumber>
    implements NumberFunc<TNumber> {
        SimpleCastNumberFunc() {
        }

        @Override
        public Number getValue(TNumber item) {
            return (Number)item;
        }
    }
}

