/*
 * Decompiled with CFR 0.152.
 */
package de.renebergelt.quiterables.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class LazyIterator<T>
implements Iterator<T> {
    protected T nextElement = null;
    protected boolean ended = false;

    @Override
    public boolean hasNext() {
        if (this.ended) {
            return false;
        }
        if (this.nextElement == null) {
            this.nextElement = this.nextElement();
        }
        return this.nextElement != null;
    }

    @Override
    public T next() {
        if (this.ended) {
            throw new NoSuchElementException("No more elements in iterator. Use hasNext() to check before calling next().");
        }
        T currentElement = this.nextElement;
        this.nextElement = null;
        return currentElement == null ? this.nextElement() : currentElement;
    }

    private T nextElement() {
        if (!this.ended) {
            T element = this.findNextElement();
            if (element == null) {
                this.ended = true;
            }
            return element;
        }
        return null;
    }

    protected abstract T findNextElement();

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

