/*
 * Decompiled with CFR 0.152.
 */
package de.renebergelt.quiterables.iterators;

import de.renebergelt.quiterables.ItemFunc;
import de.renebergelt.quiterables.SortOrder;
import de.renebergelt.quiterables.iterators.NaturalComparator;
import de.renebergelt.quiterables.iterators.OrderFunc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class LazyOrderIterable<T, TComparable>
implements Iterable<T> {
    Iterable<T> wrapped;
    List<OrderFunc> orderFuncs;
    List<T> sortedList;
    static final NaturalComparator defaultComparator = new NaturalComparator();

    public <TComparable> LazyOrderIterable(Iterable<T> _wrapped, ItemFunc<T, TComparable> valueFunc, Comparator comparator, SortOrder sortOrder) {
        this.wrapped = _wrapped;
        this.orderFuncs = new ArrayList<OrderFunc>();
        this.orderFuncs.add(new OrderFunc<T, TComparable>(valueFunc, comparator, sortOrder));
    }

    public LazyOrderIterable(Iterable<T> _wrapped, ItemFunc<T, Comparable> valueFunc, SortOrder sortOrder) {
        this(_wrapped, valueFunc, defaultComparator, sortOrder);
    }

    public void addSecondaryOrderFunction(ItemFunc<T, Comparable> func, SortOrder sortOrder) {
        this.orderFuncs.add(new OrderFunc<T, Comparable>(func, defaultComparator, sortOrder));
    }

    public <TComparable> void addSecondaryOrderFunction(ItemFunc<T, TComparable> func, Comparator<TComparable> comparator, SortOrder sortOrder) {
        this.orderFuncs.add(new OrderFunc<T, TComparable>(func, comparator, sortOrder));
    }

    @Override
    public Iterator<T> iterator() {
        if (this.sortedList == null) {
            this.sortedList = new ArrayList<T>();
            for (T element : this.wrapped) {
                this.sortedList.add(element);
            }
            Collections.sort(this.sortedList, new Comparator<T>(){

                @Override
                public int compare(T item1, T item2) {
                    int result = 0;
                    for (OrderFunc f : LazyOrderIterable.this.orderFuncs) {
                        result = f.compare(item1, item2);
                        if (result == 0) continue;
                        return result;
                    }
                    return result;
                }
            });
        }
        return this.sortedList.iterator();
    }
}

