/*
 * Decompiled with CFR 0.152.
 */
package de.renebergelt.quiterables.iterators;

import de.renebergelt.quiterables.Selector;
import de.renebergelt.quiterables.iterators.LazyIterator;
import java.util.Iterator;

class LazySelectManyIterator<TIn, TOut>
extends LazyIterator<TOut> {
    Iterator<TIn> wrapped;
    Iterator<TOut> subIter;
    Selector<TIn, Iterable<TOut>> selectorFunc;

    public LazySelectManyIterator(Iterator<TIn> _wrapped, Selector<TIn, Iterable<TOut>> _selectorFunc) {
        this.wrapped = _wrapped;
        this.selectorFunc = _selectorFunc;
    }

    @Override
    protected TOut findNextElement() {
        while (true) {
            if (this.subIter != null) {
                if (this.subIter.hasNext()) {
                    return this.subIter.next();
                }
                this.subIter = null;
            }
            if (!this.wrapped.hasNext()) {
                return null;
            }
            this.subIter = this.selectorFunc.select(this.wrapped.next()).iterator();
        }
    }
}

