/*
 * Decompiled with CFR 0.152.
 */
package de.renebergelt.quiterables.iterators;

import de.renebergelt.quiterables.Predicate;
import de.renebergelt.quiterables.iterators.LazyIterator;
import java.util.Iterator;

class LazySkipWhileIterator<T>
extends LazyIterator<T> {
    Iterator<T> wrapped;
    T nextElement = null;
    Predicate<T> skipWhileCondition;
    boolean skippingDone = false;

    public LazySkipWhileIterator(Iterator<T> _wrapped, Predicate<T> _skipWhileCondition) {
        this.wrapped = _wrapped;
        this.skipWhileCondition = _skipWhileCondition;
    }

    @Override
    protected T findNextElement() {
        if (this.skippingDone) {
            return this.wrapped.hasNext() ? (T)this.wrapped.next() : null;
        }
        while (this.wrapped.hasNext()) {
            T element = this.wrapped.next();
            if (this.skipWhileCondition.evaluate(element)) continue;
            this.skippingDone = true;
            return element;
        }
        return null;
    }
}

