/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.demo;

import de.richtercloud.message.handler.ConfirmMessageHandler;
import de.richtercloud.message.handler.DialogConfirmMessageHandler;
import de.richtercloud.message.handler.IssueHandler;
import de.richtercloud.message.handler.LoggerIssueHandler;
import de.richtercloud.reflection.form.builder.demo.EntityA;
import de.richtercloud.reflection.form.builder.demo.EntityB;
import de.richtercloud.reflection.form.builder.demo.EntityC;
import de.richtercloud.reflection.form.builder.demo.EntityD;
import de.richtercloud.reflection.form.builder.demo.QueryPanelDemo;
import de.richtercloud.reflection.form.builder.jpa.IdGenerator;
import de.richtercloud.reflection.form.builder.jpa.MemorySequentialIdGenerator;
import de.richtercloud.reflection.form.builder.jpa.idapplier.GeneratedValueIdApplier;
import de.richtercloud.reflection.form.builder.jpa.idapplier.IdApplier;
import de.richtercloud.reflection.form.builder.jpa.retriever.JPAOrderedCachedFieldRetriever;
import de.richtercloud.reflection.form.builder.jpa.storage.DerbyEmbeddedPersistenceStorage;
import de.richtercloud.reflection.form.builder.jpa.storage.DerbyEmbeddedPersistenceStorageConf;
import de.richtercloud.reflection.form.builder.jpa.storage.PersistenceStorage;
import de.richtercloud.reflection.form.builder.retriever.FieldOrderValidationException;
import de.richtercloud.reflection.form.builder.storage.StorageConfValidationException;
import de.richtercloud.reflection.form.builder.storage.StorageCreationException;
import de.richtercloud.validation.tools.FieldRetriever;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDemo
extends JFrame {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDemo.class);
    private final Connection connection;
    private final IssueHandler issueHandler = new LoggerIssueHandler(LOGGER);
    private final ConfirmMessageHandler confirmMessageHandler = new DialogConfirmMessageHandler((Frame)this);
    private final IdApplier idApplier = new GeneratedValueIdApplier();
    private final IdGenerator idGenerator = MemorySequentialIdGenerator.getInstance();
    private final String databaseName;
    private final File parentDir = new File("/tmp/reflection-form-builder-demo");
    private final PersistenceStorage storage;
    private final Set<Class<?>> entityClasses;
    private final File schemeChecksumFile;
    private final FieldRetriever fieldRetriever;

    public AbstractDemo() throws SQLException, IOException, StorageConfValidationException, StorageCreationException, FieldOrderValidationException {
        if (!this.parentDir.exists()) {
            this.parentDir.mkdir();
        }
        String databaseDirName = "databases";
        this.databaseName = new File(this.parentDir, databaseDirName).getAbsolutePath();
        try {
            Class<EmbeddedDriver> driver = EmbeddedDriver.class;
            driver.newInstance();
            this.connection = DriverManager.getConnection(String.format("jdbc:derby:%s;create=%s", this.databaseName, !new File(this.databaseName).exists()));
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                LOGGER.info("running {} shutdown hooks", QueryPanelDemo.class);
                if (this.connection != null) {
                    try {
                        this.connection.close();
                    }
                    catch (SQLException ex) {
                        LOGGER.error("an exception during shutdown of the database connection occured", (Throwable)ex);
                    }
                }
            }, String.format("%s shutdown hook", this.getClass().getSimpleName())));
        }
        catch (IllegalAccessException | InstantiationException ex) {
            JOptionPane.showMessageDialog(null, String.format("<html>An unexpected exception occured during the initialization of resources (%s)</html>", ex.getMessage()), String.format("Error in initialization of resources - %s", this.getAppName()), 0);
            LOGGER.error("An unexpected exception occured during the initialization of resources (see nested exception for details)", (Throwable)ex);
            throw new ExceptionInInitializerError(ex);
        }
        this.entityClasses = new HashSet<Class>(Arrays.asList(EntityA.class, EntityB.class, EntityC.class, EntityD.class));
        this.fieldRetriever = new JPAOrderedCachedFieldRetriever(this.entityClasses);
        this.schemeChecksumFile = new File(this.getParentDir(), "scheme-checksum");
        this.storage = new DerbyEmbeddedPersistenceStorage(new DerbyEmbeddedPersistenceStorageConf(this.entityClasses, this.getDatabaseName(), this.schemeChecksumFile), "richtercloud_reflection-form-builder-demo_jar_1.0-SNAPSHOTPU", 1, this.fieldRetriever);
        this.storage.start();
    }

    protected abstract String getAppName();

    public File getParentDir() {
        return this.parentDir;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public IssueHandler getIssueHandler() {
        return this.issueHandler;
    }

    public IdApplier getIdApplier() {
        return this.idApplier;
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public ConfirmMessageHandler getConfirmMessageHandler() {
        return this.confirmMessageHandler;
    }

    public PersistenceStorage getStorage() {
        return this.storage;
    }

    public Set<Class<?>> getEntityClasses() {
        return this.entityClasses;
    }

    public File getSchemeChecksumFile() {
        return this.schemeChecksumFile;
    }

    public FieldRetriever getFieldRetriever() {
        return this.fieldRetriever;
    }
}

