/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.demo;

import de.richtercloud.message.handler.DialogMessageHandler;
import de.richtercloud.message.handler.ExceptionMessage;
import de.richtercloud.message.handler.IssueHandler;
import de.richtercloud.message.handler.LoggerIssueHandler;
import de.richtercloud.message.handler.Message;
import de.richtercloud.message.handler.MessageHandler;
import de.richtercloud.reflection.form.builder.ResetException;
import de.richtercloud.reflection.form.builder.demo.AbstractDemo;
import de.richtercloud.reflection.form.builder.demo.EntityA;
import de.richtercloud.reflection.form.builder.demo.EntityB;
import de.richtercloud.reflection.form.builder.demo.EntityC;
import de.richtercloud.reflection.form.builder.demo.JPAReflectionFormBuilderDemo;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandlingException;
import de.richtercloud.reflection.form.builder.jpa.panels.QueryHistoryEntryStorage;
import de.richtercloud.reflection.form.builder.jpa.panels.QueryHistoryEntryStorageCreationException;
import de.richtercloud.reflection.form.builder.jpa.panels.QueryListPanel;
import de.richtercloud.reflection.form.builder.jpa.panels.XMLFileQueryHistoryEntryStorageFactory;
import de.richtercloud.reflection.form.builder.jpa.retriever.JPAOrderedCachedFieldRetriever;
import de.richtercloud.reflection.form.builder.jpa.storage.FieldInitializer;
import de.richtercloud.reflection.form.builder.jpa.storage.ReflectionFieldInitializer;
import de.richtercloud.reflection.form.builder.retriever.FieldOrderValidationException;
import de.richtercloud.reflection.form.builder.storage.StorageConfValidationException;
import de.richtercloud.reflection.form.builder.storage.StorageCreationException;
import de.richtercloud.reflection.form.builder.storage.StorageException;
import de.richtercloud.validation.tools.FieldRetriever;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryListPanelDemo
extends AbstractDemo {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryListPanelDemo.class);
    private static final Random RANDOM = new Random();
    private static final String APP_NAME = "Query list panel demo";
    private static Long nextId = 1L;
    private static final String BIDIRECTIONAL_HELP_DIALOG_TITLE = String.format("%s - Info", JPAReflectionFormBuilderDemo.class.getSimpleName());
    private final Class<?> entityClass = EntityA.class;
    private final Set<Class<?>> entityClasses = new HashSet<Class>(Arrays.asList(this.entityClass));
    private final List<Object> initialValues = new LinkedList<Object>();
    private final IssueHandler issueHandler = new LoggerIssueHandler(LOGGER);
    private final QueryListPanel queryListPanel;
    private JButton createAButton;
    private JButton createBButton;
    private JButton createCButton;

    private static Long getNextId() {
        nextId = nextId + 1L;
        return nextId;
    }

    public static void main(String[] args) {
        DialogMessageHandler messageHandler = new DialogMessageHandler(null);
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            messageHandler.handle((Message)new ExceptionMessage((Throwable)ex));
            return;
        }
        EventQueue.invokeLater(new Runnable((MessageHandler)messageHandler){
            final /* synthetic */ MessageHandler val$messageHandler;
            {
                this.val$messageHandler = messageHandler;
            }

            @Override
            public void run() {
                try {
                    new QueryListPanelDemo().setVisible(true);
                }
                catch (ResetException | FieldHandlingException | QueryHistoryEntryStorageCreationException | FieldOrderValidationException | StorageConfValidationException | StorageCreationException | StorageException | IOException | IllegalAccessException | NoSuchFieldException | SQLException ex) {
                    this.val$messageHandler.handle((Message)new ExceptionMessage(ex));
                }
            }
        });
    }

    public QueryListPanelDemo() throws IOException, SQLException, StorageException, StorageCreationException, StorageConfValidationException, QueryHistoryEntryStorageCreationException, NoSuchFieldException, ResetException, IllegalArgumentException, IllegalAccessException, FieldOrderValidationException, FieldHandlingException {
        JPAOrderedCachedFieldRetriever fieldRetriever = new JPAOrderedCachedFieldRetriever(this.entityClasses);
        ReflectionFieldInitializer fieldInitializer = new ReflectionFieldInitializer((FieldRetriever)fieldRetriever);
        File entryStorageFile = File.createTempFile(QueryListPanelDemo.class.getSimpleName(), null);
        XMLFileQueryHistoryEntryStorageFactory entryStorageFactory = new XMLFileQueryHistoryEntryStorageFactory(entryStorageFile, this.getEntityClasses(), false, this.getIssueHandler());
        QueryHistoryEntryStorage entryStorage = entryStorageFactory.create();
        this.queryListPanel = new QueryListPanel(this.getStorage(), (FieldRetriever)fieldRetriever, this.entityClass, this.issueHandler, this.initialValues, BIDIRECTIONAL_HELP_DIALOG_TITLE, (FieldInitializer)fieldInitializer, entryStorage);
        this.initComponents();
    }

    private void initComponents() {
        this.createAButton = new JButton();
        this.createCButton = new JButton();
        this.createBButton = new JButton();
        this.setDefaultCloseOperation(3);
        this.setBounds(new Rectangle(0, 0, 500, 300));
        this.createAButton.setText("Create new A (references B)");
        this.createAButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    QueryListPanelDemo.this.createAButtonActionPerformed(evt);
                }
                catch (StorageException ex) {
                    QueryListPanelDemo.this.issueHandler.handle((Message)new ExceptionMessage((Throwable)ex));
                }
            }
        });
        this.createCButton.setText("Create new C (extends A)");
        this.createCButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    QueryListPanelDemo.this.createCButtonActionPerformed(evt);
                }
                catch (StorageException ex) {
                    QueryListPanelDemo.this.issueHandler.handle((Message)new ExceptionMessage((Throwable)ex));
                }
            }
        });
        this.createBButton.setText("Create new B");
        this.createBButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    QueryListPanelDemo.this.createBButtonActionPerformed(evt);
                }
                catch (StorageException ex) {
                    QueryListPanelDemo.this.issueHandler.handle((Message)new ExceptionMessage((Throwable)ex));
                }
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent((Component)this.queryListPanel).addGroup(layout.createSequentialGroup().addComponent(this.createAButton).addComponent(this.createBButton).addComponent(this.createCButton)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent((Component)this.queryListPanel).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.createAButton).addComponent(this.createBButton).addComponent(this.createCButton)));
        this.pack();
    }

    private void createAButtonActionPerformed(ActionEvent evt) throws StorageException {
        Long nextId0 = QueryListPanelDemo.getNextId();
        EntityA newA = new EntityA(nextId0, RANDOM.nextInt(), String.valueOf(RANDOM.nextInt()));
        this.getStorage().store((Object)newA);
        LOGGER.info("Create and persisted new instance of {}", (Object)EntityA.class.getName());
    }

    private void createCButtonActionPerformed(ActionEvent evt) throws StorageException {
        Long nextId0 = QueryListPanelDemo.getNextId();
        EntityC newC = new EntityC(nextId0, RANDOM.nextInt(), String.valueOf(RANDOM.nextInt()), String.valueOf(RANDOM.nextInt()));
        this.getStorage().store((Object)newC);
        LOGGER.info("Create and persisted new instance of {}", (Object)EntityC.class.getName());
    }

    private void createBButtonActionPerformed(ActionEvent evt) throws StorageException {
        Long nextId0 = QueryListPanelDemo.getNextId();
        List as = this.getStorage().runQueryAll(EntityA.class);
        EntityA randomA = null;
        if (!as.isEmpty()) {
            randomA = (EntityA)as.get(RANDOM.nextInt(as.size()));
        }
        EntityB newB = new EntityB(nextId0, RANDOM.nextInt(), randomA);
        this.getStorage().store((Object)newB);
        LOGGER.info("Create and persisted new instance of {}", (Object)EntityB.class.getName());
    }

    @Override
    protected String getAppName() {
        return APP_NAME;
    }
}

