/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.demo;

import de.richtercloud.message.handler.DialogMessageHandler;
import de.richtercloud.message.handler.ExceptionMessage;
import de.richtercloud.message.handler.IssueHandler;
import de.richtercloud.message.handler.LoggerIssueHandler;
import de.richtercloud.message.handler.Message;
import de.richtercloud.message.handler.MessageHandler;
import de.richtercloud.reflection.form.builder.ResetException;
import de.richtercloud.reflection.form.builder.demo.AbstractDemo;
import de.richtercloud.reflection.form.builder.demo.EntityA;
import de.richtercloud.reflection.form.builder.demo.EntityB;
import de.richtercloud.reflection.form.builder.demo.EntityC;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandlingException;
import de.richtercloud.reflection.form.builder.jpa.panels.BidirectionalControlPanel;
import de.richtercloud.reflection.form.builder.jpa.panels.QueryHistoryEntry;
import de.richtercloud.reflection.form.builder.jpa.panels.QueryHistoryEntryStorage;
import de.richtercloud.reflection.form.builder.jpa.panels.QueryHistoryEntryStorageCreationException;
import de.richtercloud.reflection.form.builder.jpa.panels.QueryPanel;
import de.richtercloud.reflection.form.builder.jpa.panels.XMLFileQueryHistoryEntryStorageFactory;
import de.richtercloud.reflection.form.builder.jpa.retriever.JPAOrderedCachedFieldRetriever;
import de.richtercloud.reflection.form.builder.jpa.storage.FieldInitializer;
import de.richtercloud.reflection.form.builder.jpa.storage.ReflectionFieldInitializer;
import de.richtercloud.reflection.form.builder.retriever.FieldOrderValidationException;
import de.richtercloud.reflection.form.builder.storage.StorageConfValidationException;
import de.richtercloud.reflection.form.builder.storage.StorageCreationException;
import de.richtercloud.reflection.form.builder.storage.StorageException;
import de.richtercloud.validation.tools.FieldRetriever;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryPanelDemo
extends AbstractDemo {
    private static final long serialVersionUID = 1L;
    private static final String APP_NAME = "reflection-form-builder-demo";
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryPanelDemo.class);
    private static Long nextId = 1L;
    private static final Random RANDOM = new Random();
    private static final List<QueryHistoryEntry> QUERY_PANEL_INITIAL_HISTORY = new LinkedList<QueryHistoryEntry>();
    private final IssueHandler issueHandler = new LoggerIssueHandler(LOGGER);
    private final Class<?> entityClass = EntityA.class;
    private final Set<Class<?>> entityClasses = new HashSet<Class>(Arrays.asList(EntityA.class, EntityB.class, EntityC.class));
    private final FieldRetriever fieldRetriever = new JPAOrderedCachedFieldRetriever(this.entityClasses);
    private final JButton createAButton = new JButton();
    private final JButton createBButton = new JButton();
    private final JButton createCButton = new JButton();
    private final QueryPanel<EntityA> queryPanel = this.createQueryPanel();

    private static Long getNextId() {
        nextId = nextId + 1L;
        return nextId;
    }

    public QueryPanelDemo() throws IOException, IllegalArgumentException, FieldHandlingException, FieldOrderValidationException, QueryHistoryEntryStorageCreationException, ResetException, SQLException, StorageConfValidationException, StorageCreationException {
        this.initComponents();
    }

    private QueryPanel createQueryPanel() throws FieldHandlingException, IOException, QueryHistoryEntryStorageCreationException, ResetException {
        String bidirectionalHelpDialogTitle = String.format("%s - Info", QueryPanelDemo.class.getSimpleName());
        List entityClassFields = this.fieldRetriever.retrieveRelevantFields(this.entityClass);
        Set mappedFieldCandidates = QueryPanel.retrieveMappedFieldCandidates(this.entityClass, (List)entityClassFields);
        BidirectionalControlPanel bidirectionalControlPanel = new BidirectionalControlPanel(this.entityClass, bidirectionalHelpDialogTitle, QueryPanel.retrieveMappedByFieldPanel((List)entityClassFields), mappedFieldCandidates);
        ReflectionFieldInitializer fieldInitializer = new ReflectionFieldInitializer(this.fieldRetriever);
        File entryStorageFile = File.createTempFile(QueryPanelDemo.class.getSimpleName(), null);
        XMLFileQueryHistoryEntryStorageFactory entryStorageFactory = new XMLFileQueryHistoryEntryStorageFactory(entryStorageFile, this.getEntityClasses(), false, this.getIssueHandler());
        QueryHistoryEntryStorage entryStorage = entryStorageFactory.create();
        return new QueryPanel(this.getStorage(), this.entityClass, this.issueHandler, this.fieldRetriever, null, bidirectionalControlPanel, 0, (FieldInitializer)fieldInitializer, entryStorage);
    }

    @Override
    protected String getAppName() {
        return APP_NAME;
    }

    private void initComponents() {
        this.setDefaultCloseOperation(3);
        this.setBounds(new Rectangle(0, 0, 0, 0));
        this.createAButton.setText("Create new A (references B)");
        this.createAButton.addActionListener(evt -> this.createAButtonActionPerformed(evt));
        this.createBButton.setText("Create new B");
        this.createBButton.addActionListener(evt -> this.createBButtonActionPerformed(evt));
        this.createCButton.setText("Create new C (extends A)");
        this.createCButton.addActionListener(evt -> this.createCButtonActionPerformed(evt));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(236, Short.MAX_VALUE).addComponent(this.createCButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.createBButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.createAButton).addContainerGap()).addComponent((Component)this.queryPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent((Component)this.queryPanel, -1, 511, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.createAButton).addComponent(this.createBButton).addComponent(this.createCButton)).addContainerGap()));
        this.pack();
    }

    private void createAButtonActionPerformed(ActionEvent evt) {
        Long nextId0 = QueryPanelDemo.getNextId();
        EntityA newA = new EntityA(nextId0, RANDOM.nextInt(), String.valueOf(RANDOM.nextInt()));
        try {
            this.getStorage().store((Object)newA);
        }
        catch (StorageException ex) {
            this.issueHandler.handle((Message)new ExceptionMessage((Throwable)ex));
        }
        LOGGER.info("Create and persisted new instance of {}", (Object)EntityA.class.getName());
    }

    private void createBButtonActionPerformed(ActionEvent evt) {
        Long nextId0 = QueryPanelDemo.getNextId();
        List as = this.getStorage().runQueryAll(EntityA.class);
        EntityA randomA = null;
        if (!as.isEmpty()) {
            randomA = (EntityA)as.get(RANDOM.nextInt(as.size()));
        }
        EntityB newB = new EntityB(nextId0, RANDOM.nextInt(), randomA);
        try {
            this.getStorage().store((Object)newB);
        }
        catch (StorageException ex) {
            this.issueHandler.handle((Message)new ExceptionMessage((Throwable)ex));
        }
        LOGGER.info("Create and persisted new instance of {}", (Object)EntityB.class.getName());
    }

    private void createCButtonActionPerformed(ActionEvent evt) {
        Long nextId0 = QueryPanelDemo.getNextId();
        EntityC newC = new EntityC(nextId0, RANDOM.nextInt(), String.valueOf(RANDOM.nextInt()), String.valueOf(RANDOM.nextInt()));
        try {
            this.getStorage().store((Object)newC);
        }
        catch (StorageException ex) {
            this.issueHandler.handle((Message)new ExceptionMessage((Throwable)ex));
        }
        LOGGER.info("Create and persisted new instance of {}", (Object)EntityC.class.getName());
    }

    public static void main(String[] args) {
        DialogMessageHandler messageHandler = new DialogMessageHandler(null);
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            messageHandler.handle((Message)new ExceptionMessage((Throwable)ex));
            return;
        }
        EventQueue.invokeLater(() -> QueryPanelDemo.lambda$main$3((MessageHandler)messageHandler));
    }

    private static /* synthetic */ void lambda$main$3(MessageHandler messageHandler) {
        try {
            new QueryPanelDemo().setVisible(true);
        }
        catch (ResetException | FieldHandlingException | QueryHistoryEntryStorageCreationException | FieldOrderValidationException | StorageConfValidationException | StorageCreationException | IOException | IllegalArgumentException | SQLException ex) {
            messageHandler.handle((Message)new ExceptionMessage(ex));
        }
    }

    static {
        QUERY_PANEL_INITIAL_HISTORY.add(new QueryHistoryEntry("select a from EntityA a", 1, new Date()));
        QUERY_PANEL_INITIAL_HISTORY.add(new QueryHistoryEntry("select b from EntityB b", 5, new Date()));
        QUERY_PANEL_INITIAL_HISTORY.add(new QueryHistoryEntry("select c from EntityC c", 3, new Date()));
    }
}

