/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.demo;

import de.richtercloud.message.handler.DialogMessageHandler;
import de.richtercloud.message.handler.ExceptionMessage;
import de.richtercloud.message.handler.IssueHandler;
import de.richtercloud.message.handler.LoggerIssueHandler;
import de.richtercloud.message.handler.Message;
import de.richtercloud.message.handler.MessageHandler;
import de.richtercloud.reflection.form.builder.ReflectionFormBuilder;
import de.richtercloud.reflection.form.builder.ReflectionFormPanel;
import de.richtercloud.reflection.form.builder.ResetException;
import de.richtercloud.reflection.form.builder.TransformationException;
import de.richtercloud.reflection.form.builder.demo.EntityA;
import de.richtercloud.reflection.form.builder.demo.EntityB;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandler;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateEvent;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateListener;
import de.richtercloud.reflection.form.builder.fieldhandler.IntegerListFieldHandler;
import de.richtercloud.reflection.form.builder.fieldhandler.MappingFieldHandler;
import de.richtercloud.reflection.form.builder.fieldhandler.SimpleEntityListFieldHandler;
import de.richtercloud.reflection.form.builder.fieldhandler.factory.MappingFieldHandlerFactory;
import de.richtercloud.reflection.form.builder.jpa.retriever.JPAOrderedCachedFieldRetriever;
import de.richtercloud.reflection.form.builder.retriever.FieldOrderValidationException;
import de.richtercloud.validation.tools.FieldRetriever;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionFormBuilderDemo
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectionFormBuilderDemo.class);
    private final ReflectionFormPanel reflectionPanel;
    private final IssueHandler issueHandler = new LoggerIssueHandler(LOGGER);
    private JButton displayButton;
    private JPanel mainPanel;

    public ReflectionFormBuilderDemo() throws TransformationException, NoSuchFieldException, ResetException, FieldOrderValidationException {
        this.initComponents();
        MappingFieldHandlerFactory fieldHandlerFactory = new MappingFieldHandlerFactory(this.issueHandler);
        Map classMapping = fieldHandlerFactory.generateClassMapping();
        classMapping.put(EntityA.class.getDeclaredField("elementCollectionBasics").getGenericType(), new IntegerListFieldHandler(this.issueHandler));
        classMapping.put(EntityA.class.getDeclaredField("oneToManyEntityBs").getGenericType(), new SimpleEntityListFieldHandler(this.issueHandler));
        classMapping.put(EntityB.class, new FieldHandler<Boolean, FieldUpdateEvent<Boolean>, ReflectionFormBuilder, Component>(){

            public JComponent handle(Field field, Object instance, final FieldUpdateListener<FieldUpdateEvent<Boolean>> updateListener, ReflectionFormBuilder reflectionFormBuilder) {
                final JCheckBox retValue = new JCheckBox("This checkbox represents an EntityB!");
                retValue.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        updateListener.onUpdate(new FieldUpdateEvent((Object)retValue.isSelected()));
                    }
                });
                return retValue;
            }

            public void reset(Component component) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        });
        HashSet<Class> entityClasses = new HashSet<Class>(Arrays.asList(EntityA.class, EntityB.class));
        MappingFieldHandler fieldHandler = new MappingFieldHandler(classMapping, fieldHandlerFactory.generatePrimitiveMapping(), this.issueHandler);
        ReflectionFormBuilder reflectionFormBuilder = new ReflectionFormBuilder("Field description", this.issueHandler, (FieldRetriever)new JPAOrderedCachedFieldRetriever(entityClasses));
        this.reflectionPanel = reflectionFormBuilder.transformEntityClass(EntityA.class, null, (FieldHandler)fieldHandler);
        BoxLayout mainPanelLayout = new BoxLayout(this.mainPanel, 0);
        this.mainPanel.setLayout(mainPanelLayout);
        this.mainPanel.add((Component)this.reflectionPanel);
        this.mainPanel.validate();
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.displayButton = new JButton();
        this.setDefaultCloseOperation(3);
        this.setBounds(new Rectangle(0, 0, 0, 0));
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 622, Short.MAX_VALUE));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 375, Short.MAX_VALUE));
        this.displayButton.setText("Display instance info");
        this.displayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReflectionFormBuilderDemo.this.displayButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainPanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.displayButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.mainPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.displayButton).addContainerGap()));
        this.pack();
    }

    private void displayButtonActionPerformed(ActionEvent evt) {
        Object instance = this.reflectionPanel.retrieveInstance();
        ReflectionFormBuilderDemo.displayInstanceInfoDialog(this, instance);
    }

    public static void displayInstanceInfoDialog(Frame owner, Object instance) {
        JDialog displayDialog = new JDialog(owner, String.format("Info - %s", ReflectionFormBuilderDemo.class.getSimpleName()), true);
        displayDialog.getContentPane().setLayout(new BorderLayout());
        displayDialog.getContentPane().add(new JLabel(String.format("<html>%s</html>", instance.toString())));
        displayDialog.setPreferredSize(new Dimension(500, 300));
        displayDialog.pack();
        displayDialog.setVisible(true);
    }

    public static void main(String[] args) {
        DialogMessageHandler messageHandler = new DialogMessageHandler(null);
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            messageHandler.handle((Message)new ExceptionMessage((Throwable)ex));
            return;
        }
        EventQueue.invokeLater(new Runnable((MessageHandler)messageHandler){
            final /* synthetic */ MessageHandler val$messageHandler;
            {
                this.val$messageHandler = messageHandler;
            }

            @Override
            public void run() {
                try {
                    new ReflectionFormBuilderDemo().setVisible(true);
                }
                catch (ResetException | TransformationException | FieldOrderValidationException | NoSuchFieldException ex) {
                    this.val$messageHandler.handle((Message)new ExceptionMessage(ex));
                }
            }
        });
    }
}

