/**
 * Copyright 2018 Karl-Philipp Richter
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package de.richtercloud.selenium.tools;

import java.io.IOException;
import java.net.HttpURLConnection;
import org.apache.commons.compress.utils.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;

/**
 *
 * @author richter
 */
public class ResponseCodeUnequalsException extends RuntimeException {
    private static final long serialVersionUID = 1L;

    public ResponseCodeUnequalsException(HttpURLConnection uRLConnection) throws IOException {
        super(String.format("response code was %d and response text '%s'",
                uRLConnection.getResponseCode(),
                IOUtils.toString(uRLConnection.getErrorStream() != null
                        ? uRLConnection.getErrorStream()
                        : uRLConnection.getInputStream(),
                        Charsets.UTF_8)));
    }

    public ResponseCodeUnequalsException(HttpResponse httpResponse) throws IOException {
        super(String.format("response code was %d and response text '%s'",
                httpResponse.getStatusLine().getStatusCode(),
                IOUtils.toString(httpResponse.getEntity().getContent(),
                        Charsets.UTF_8)));
    }
}
