/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx.attach.impl;

import com.mortennobel.imagescaling.ResampleOp;
import de.rpgframework.core.RoleplayingSystem;
import de.rpgframework.jfx.attach.PDFViewerConfig;
import de.rpgframework.jfx.attach.PDFViewerService;
import java.awt.image.BufferedImage;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import javafx.application.Platform;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadBufferedFile;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.prelle.javafx.FlexibleApplication;
import org.prelle.javafx.SymbolIcon;

public class DesktopPDFViewerService
implements PDFViewerService,
Runnable {
    private static final System.Logger logger = System.getLogger("rpgframework.pdf");
    private static String path = "/";
    private static ImageView iView;
    private static Scene scene;
    private static Stage stage;
    private static VBox parent;
    private static ButtonBar bar;
    private static Button btnPrev;
    private static Button btnNext;
    private static int currentPage;
    private static Thread displayThread;
    private static int nextPage;
    private static String nextPath;
    private static PDDocument pdDocument;
    private static PDFRenderer renderer;

    public DesktopPDFViewerService() {
        System.out.println("DesktopPDFViewerService");
        logger.log(System.Logger.Level.INFO, "Initializing DesktopPDFViewerService via PDFBox");
        displayThread = new Thread((Runnable)this, "PDFViewer");
        displayThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            System.Logger logger = DesktopPDFViewerService.logger;
            synchronized (logger) {
                try {
                    DesktopPDFViewerService.logger.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            DesktopPDFViewerService.logger.log(System.Logger.Level.INFO, "Render page {0} of {1}", nextPage, nextPath);
            try {
                Instant start;
                if (!nextPath.equals(path)) {
                    start = Instant.now();
                    DesktopPDFViewerService.logger.log(System.Logger.Level.INFO, "Load PDF");
                    FlexibleApplication.getInstance().getAppLayout().getScene().setCursor(Cursor.WAIT);
                    DesktopPDFViewerService.logger.log(System.Logger.Level.INFO, "Opening input stream");
                    DesktopPDFViewerService.logger.log(System.Logger.Level.INFO, "Calling  PDDocument.load");
                    pdDocument = Loader.loadPDF((RandomAccessRead)new RandomAccessReadBufferedFile(nextPath), null, null, null, null);
                    DesktopPDFViewerService.logger.log(System.Logger.Level.INFO, "Calling new PDFRenderer");
                    renderer = new PDFRenderer(pdDocument);
                    path = nextPath;
                    DesktopPDFViewerService.logger.log(System.Logger.Level.INFO, "PDF newly loaded within {0} ms", Duration.between(start, Instant.now()).toMillis());
                    FlexibleApplication.getInstance().getAppLayout().getScene().setCursor(Cursor.DEFAULT);
                }
                if (nextPage != currentPage) {
                    start = Instant.now();
                    DesktopPDFViewerService.logger.log(System.Logger.Level.INFO, "Start Rendering page {0}", nextPage);
                    DesktopPDFViewerService.logger.log(System.Logger.Level.INFO, "Hints {0}", renderer.getRenderingHints());
                    BufferedImage image = renderer.renderImageWithDPI(nextPage, 300.0f, ImageType.RGB);
                    ResampleOp resampleOp = new ResampleOp(image.getWidth() / 3, image.getHeight() / 3);
                    image = resampleOp.filter(image, null);
                    image.createGraphics();
                    WritableImage fxImg = SwingFXUtils.toFXImage((BufferedImage)image, null);
                    iView.setImage((Image)fxImg);
                    stage.setHeight(fxImg.getHeight() + 56.0 + bar.getHeight());
                    stage.setWidth(fxImg.getWidth() + 11.0);
                    parent.requestLayout();
                    currentPage = nextPage;
                    DesktopPDFViewerService.logger.log(System.Logger.Level.INFO, "Rendering done in {0} ms", Duration.between(start, Instant.now()).toMillis());
                }
                if (stage.isShowing()) continue;
                if (Platform.isFxApplicationThread()) {
                    stage.show();
                    continue;
                }
                Platform.runLater(() -> stage.show());
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
                Image fxImg = new Image(ClassLoader.getSystemResourceAsStream("Rendering.jpg"));
                iView.setImage(fxImg);
                stage.setHeight(fxImg.getHeight() + 56.0 + bar.getHeight());
                stage.setWidth(fxImg.getWidth() + 11.0);
                parent.requestLayout();
                if (stage.isShowing()) continue;
                if (Platform.isFxApplicationThread()) {
                    stage.show();
                    continue;
                }
                Platform.runLater(() -> stage.show());
                continue;
            }
            break;
        }
    }

    private static void ensureStage() {
        if (stage == null) {
            iView = new ImageView();
            Image fxImg = new Image(ClassLoader.getSystemResourceAsStream("Rendering.jpg"));
            iView.setImage(fxImg);
            btnPrev = new Button(null, (Node)new SymbolIcon("back"));
            btnNext = new Button(null, (Node)new SymbolIcon("forward"));
            btnPrev.setOnAction(ev -> {
                if (currentPage > 0) {
                    DesktopPDFViewerService.showPage(currentPage - 1);
                }
            });
            btnNext.setOnAction(ev -> DesktopPDFViewerService.showPage(currentPage + 1));
            ScrollPane scroll = new ScrollPane((Node)iView);
            scroll.setFitToWidth(true);
            bar = new ButtonBar();
            bar.getButtons().addAll((Object[])new Node[]{btnPrev, btnNext});
            parent = new VBox(10.0, new Node[]{scroll, bar});
            parent.setAlignment(Pos.CENTER);
            scene = new Scene((Parent)parent);
            scene.getStylesheets().addAll((Collection)FlexibleApplication.getInstance().getAppLayout().getScene().getStylesheets());
            stage = new Stage();
            stage.setScene(scene);
            stage.show();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void showPage(int showPage) {
        if (nextPath == null || nextPath.isEmpty()) {
            return;
        }
        nextPage = showPage;
        System.Logger logger = DesktopPDFViewerService.logger;
        synchronized (logger) {
            DesktopPDFViewerService.logger.notify();
        }
    }

    public void show(RoleplayingSystem rules, String productID, String lang, int page) {
        logger.log(System.Logger.Level.DEBUG, "Show {1} for RPG {0} in language ''{2}'' on page {3}", rules, productID, lang, page);
        if (!PDFViewerConfig.isEnabled()) {
            return;
        }
        if (PDFViewerConfig.getPDFPathResolver() == null || page == 0) {
            return;
        }
        DesktopPDFViewerService.ensureStage();
        PDFViewerConfig.PathAndOffset pair = (PDFViewerConfig.PathAndOffset)PDFViewerConfig.getPDFPathResolver().apply(productID, lang);
        nextPath = pair.path;
        page += pair.offset;
        logger.log(System.Logger.Level.INFO, "..resolved to path: {0}", nextPath);
        if (nextPath == null) {
            return;
        }
        DesktopPDFViewerService.showPage(page);
    }
}

