/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.html.simpleparser;

import com.itextpdf.text.Element;
import com.itextpdf.text.ElementListener;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.TextElementArray;
import com.itextpdf.text.html.Markup;
import com.itextpdf.text.html.simpleparser.ChainedProperties;
import com.itextpdf.text.pdf.PdfPCell;
import java.util.ArrayList;

public class IncCell
implements TextElementArray {
    private ArrayList chunks = new ArrayList();
    private PdfPCell cell = new PdfPCell((Phrase)null);

    public IncCell(String tag, ChainedProperties props) {
        String value = props.getProperty("colspan");
        if (value != null) {
            this.cell.setColspan(Integer.parseInt(value));
        }
        value = props.getProperty("align");
        if (tag.equals("th")) {
            this.cell.setHorizontalAlignment(1);
        }
        if (value != null) {
            if ("center".equalsIgnoreCase(value)) {
                this.cell.setHorizontalAlignment(1);
            } else if ("right".equalsIgnoreCase(value)) {
                this.cell.setHorizontalAlignment(2);
            } else if ("left".equalsIgnoreCase(value)) {
                this.cell.setHorizontalAlignment(0);
            } else if ("justify".equalsIgnoreCase(value)) {
                this.cell.setHorizontalAlignment(3);
            }
        }
        value = props.getProperty("valign");
        this.cell.setVerticalAlignment(5);
        if (value != null) {
            if ("top".equalsIgnoreCase(value)) {
                this.cell.setVerticalAlignment(4);
            } else if ("bottom".equalsIgnoreCase(value)) {
                this.cell.setVerticalAlignment(6);
            }
        }
        value = props.getProperty("border");
        float border = 0.0f;
        if (value != null) {
            border = Float.parseFloat(value);
        }
        this.cell.setBorderWidth(border);
        value = props.getProperty("cellpadding");
        if (value != null) {
            this.cell.setPadding(Float.parseFloat(value));
        }
        this.cell.setUseDescender(true);
        value = props.getProperty("bgcolor");
        this.cell.setBackgroundColor(Markup.decodeColor(value));
    }

    @Override
    public boolean add(Object o) {
        if (!(o instanceof Element)) {
            return false;
        }
        this.cell.addElement((Element)o);
        return true;
    }

    @Override
    public ArrayList getChunks() {
        return this.chunks;
    }

    @Override
    public boolean process(ElementListener listener) {
        return true;
    }

    @Override
    public int type() {
        return 30;
    }

    public PdfPCell getCell() {
        return this.cell;
    }

    @Override
    public boolean isContent() {
        return true;
    }

    @Override
    public boolean isNestable() {
        return true;
    }
}

