/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.parser;

import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.CMapAwareDocumentFont;
import com.itextpdf.text.pdf.PRIndirectReference;
import com.itextpdf.text.pdf.PRTokeniser;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfContentParser;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfLiteral;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.parser.ContentOperator;
import com.itextpdf.text.pdf.parser.GraphicsState;
import com.itextpdf.text.pdf.parser.Matrix;
import com.itextpdf.text.pdf.parser.RenderListener;
import com.itextpdf.text.pdf.parser.TextRenderInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;

public class PdfContentStreamProcessor {
    private Map operators;
    private PdfDictionary resources;
    private Stack gsStack = new Stack();
    private Matrix textMatrix;
    private Matrix textLineMatrix;
    private final RenderListener renderListener;

    public PdfContentStreamProcessor(RenderListener renderListener) {
        this.renderListener = renderListener;
        this.populateOperators();
        this.reset();
    }

    private void populateOperators() {
        this.operators = new HashMap();
        this.registerContentOperator("q", new PushGraphicsState());
        this.registerContentOperator("Q", new PopGraphicsState());
        this.registerContentOperator("cm", new ModifyCurrentTransformationMatrix());
        this.registerContentOperator("gs", new ProcessGraphicsStateResource());
        SetTextCharacterSpacing tcOperator = new SetTextCharacterSpacing();
        this.registerContentOperator("Tc", tcOperator);
        SetTextWordSpacing twOperator = new SetTextWordSpacing();
        this.registerContentOperator("Tw", twOperator);
        this.registerContentOperator("Tz", new SetTextHorizontalScaling());
        SetTextLeading tlOperator = new SetTextLeading();
        this.registerContentOperator("TL", tlOperator);
        this.registerContentOperator("Tf", new SetTextFont());
        this.registerContentOperator("Tr", new SetTextRenderMode());
        this.registerContentOperator("Ts", new SetTextRise());
        this.registerContentOperator("BT", new BeginText());
        this.registerContentOperator("ET", new EndText());
        TextMoveStartNextLine tdOperator = new TextMoveStartNextLine();
        this.registerContentOperator("Td", tdOperator);
        this.registerContentOperator("TD", new TextMoveStartNextLineWithLeading(tdOperator, tlOperator));
        this.registerContentOperator("Tm", new TextSetTextMatrix());
        TextMoveNextLine tstarOperator = new TextMoveNextLine(tdOperator);
        this.registerContentOperator("T*", tstarOperator);
        ShowText tjOperator = new ShowText();
        this.registerContentOperator("Tj", new ShowText());
        MoveNextLineAndShowText tickOperator = new MoveNextLineAndShowText(tstarOperator, tjOperator);
        this.registerContentOperator("'", tickOperator);
        this.registerContentOperator("\"", new MoveNextLineAndShowTextWithSpacing(twOperator, tcOperator, tickOperator));
        this.registerContentOperator("TJ", new ShowTextArray());
    }

    public void registerContentOperator(String operatorString, ContentOperator operator) {
        if (this.operators.containsKey(operatorString)) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("operator.1.already.registered", operatorString));
        }
        this.operators.put(operatorString, operator);
    }

    public void reset() {
        this.gsStack.removeAllElements();
        this.gsStack.add(new GraphicsState());
        this.textMatrix = null;
        this.textLineMatrix = null;
        this.resources = null;
    }

    private GraphicsState gs() {
        return (GraphicsState)this.gsStack.peek();
    }

    private Matrix getCurrentTextMatrix() {
        return this.textMatrix;
    }

    private Matrix getCurrentTextLineMatrix() {
        return this.textLineMatrix;
    }

    private void invokeOperator(PdfLiteral operator, ArrayList operands) {
        ContentOperator op = (ContentOperator)this.operators.get(operator.toString());
        if (op == null) {
            return;
        }
        op.invoke(this, operator, operands);
    }

    private String decode(PdfString in) {
        byte[] bytes = in.getBytes();
        return this.gs().font.decode(bytes, 0, bytes.length);
    }

    private void displayPdfString(PdfString string) {
        String unicode = this.decode(string);
        TextRenderInfo renderInfo = new TextRenderInfo(unicode, this.gs(), this.textMatrix);
        this.renderListener.renderText(renderInfo);
        this.textMatrix = new Matrix(renderInfo.getUnscaledWidth(), 0.0f).multiply(this.textMatrix);
    }

    private void applyTextAdjust(float tj) {
        float adjustBy = -tj / 1000.0f * this.gs().fontSize * this.gs().horizontalScaling;
        this.textMatrix = new Matrix(adjustBy, 0.0f).multiply(this.textMatrix);
    }

    public void processContent(byte[] contentBytes, PdfDictionary resources) {
        this.reset();
        this.resources = resources;
        try {
            PdfContentParser ps = new PdfContentParser(new PRTokeniser(contentBytes));
            ArrayList operands = new ArrayList();
            while (ps.parse(operands).size() > 0) {
                PdfLiteral operator = (PdfLiteral)operands.get(operands.size() - 1);
                this.invokeOperator(operator, operands);
            }
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    private static class EndText
    implements ContentOperator {
        private EndText() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            processor.textMatrix = null;
            processor.textLineMatrix = null;
        }
    }

    private static class BeginText
    implements ContentOperator {
        private BeginText() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            processor.textLineMatrix = processor.textMatrix = new Matrix();
        }
    }

    private static class PopGraphicsState
    implements ContentOperator {
        private PopGraphicsState() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            processor.gsStack.pop();
        }
    }

    private static class ModifyCurrentTransformationMatrix
    implements ContentOperator {
        private ModifyCurrentTransformationMatrix() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            float a = ((PdfNumber)operands.get(0)).floatValue();
            float b = ((PdfNumber)operands.get(1)).floatValue();
            float c = ((PdfNumber)operands.get(2)).floatValue();
            float d = ((PdfNumber)operands.get(3)).floatValue();
            float e = ((PdfNumber)operands.get(4)).floatValue();
            float f = ((PdfNumber)operands.get(5)).floatValue();
            Matrix matrix = new Matrix(a, b, c, d, e, f);
            GraphicsState gs = (GraphicsState)processor.gsStack.peek();
            gs.ctm = gs.ctm.multiply(matrix);
        }
    }

    private static class PushGraphicsState
    implements ContentOperator {
        private PushGraphicsState() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            GraphicsState gs = (GraphicsState)processor.gsStack.peek();
            GraphicsState copy = new GraphicsState(gs);
            processor.gsStack.push(copy);
        }
    }

    private static class ProcessGraphicsStateResource
    implements ContentOperator {
        private ProcessGraphicsStateResource() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            PdfName dictionaryName = (PdfName)operands.get(0);
            PdfDictionary extGState = processor.resources.getAsDict(PdfName.EXTGSTATE);
            if (extGState == null) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("resources.do.not.contain.extgstate.entry.unable.to.process.operator.1", operator));
            }
            PdfDictionary gsDic = extGState.getAsDict(dictionaryName);
            if (gsDic == null) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("1.is.an.unknown.graphics.state.dictionary", dictionaryName));
            }
            PdfArray fontParameter = gsDic.getAsArray(PdfName.FONT);
            if (fontParameter != null) {
                CMapAwareDocumentFont font = new CMapAwareDocumentFont((PRIndirectReference)fontParameter.getPdfObject(0));
                float size = fontParameter.getAsNumber(1).floatValue();
                processor.gs().font = font;
                processor.gs().fontSize = size;
            }
        }
    }

    private static class SetTextWordSpacing
    implements ContentOperator {
        private SetTextWordSpacing() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            PdfNumber wordSpace = (PdfNumber)operands.get(0);
            processor.gs().wordSpacing = wordSpace.floatValue();
        }
    }

    private static class SetTextCharacterSpacing
    implements ContentOperator {
        private SetTextCharacterSpacing() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            PdfNumber charSpace = (PdfNumber)operands.get(0);
            processor.gs().characterSpacing = charSpace.floatValue();
        }
    }

    private static class SetTextHorizontalScaling
    implements ContentOperator {
        private SetTextHorizontalScaling() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            PdfNumber scale = (PdfNumber)operands.get(0);
            processor.gs().horizontalScaling = scale.floatValue();
        }
    }

    private static class SetTextLeading
    implements ContentOperator {
        private SetTextLeading() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            PdfNumber leading = (PdfNumber)operands.get(0);
            processor.gs().leading = leading.floatValue();
        }
    }

    private static class SetTextRise
    implements ContentOperator {
        private SetTextRise() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            PdfNumber rise = (PdfNumber)operands.get(0);
            processor.gs().rise = rise.floatValue();
        }
    }

    private static class SetTextRenderMode
    implements ContentOperator {
        private SetTextRenderMode() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            PdfNumber render = (PdfNumber)operands.get(0);
            processor.gs().renderMode = render.intValue();
        }
    }

    private static class SetTextFont
    implements ContentOperator {
        private SetTextFont() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            CMapAwareDocumentFont font;
            PdfName fontResourceName = (PdfName)operands.get(0);
            float size = ((PdfNumber)operands.get(1)).floatValue();
            PdfDictionary fontsDictionary = processor.resources.getAsDict(PdfName.FONT);
            processor.gs().font = font = new CMapAwareDocumentFont((PRIndirectReference)fontsDictionary.get(fontResourceName));
            processor.gs().fontSize = size;
        }
    }

    private static class TextMoveStartNextLine
    implements ContentOperator {
        private TextMoveStartNextLine() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            float tx = ((PdfNumber)operands.get(0)).floatValue();
            float ty = ((PdfNumber)operands.get(1)).floatValue();
            Matrix translationMatrix = new Matrix(tx, ty);
            processor.textLineMatrix = processor.textMatrix = translationMatrix.multiply(processor.textLineMatrix);
        }
    }

    private static class TextMoveStartNextLineWithLeading
    implements ContentOperator {
        private final TextMoveStartNextLine moveStartNextLine;
        private final SetTextLeading setTextLeading;

        public TextMoveStartNextLineWithLeading(TextMoveStartNextLine moveStartNextLine, SetTextLeading setTextLeading) {
            this.moveStartNextLine = moveStartNextLine;
            this.setTextLeading = setTextLeading;
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            float ty = ((PdfNumber)operands.get(1)).floatValue();
            ArrayList<PdfNumber> tlOperands = new ArrayList<PdfNumber>(1);
            tlOperands.add(0, new PdfNumber(-ty));
            this.setTextLeading.invoke(processor, null, tlOperands);
            this.moveStartNextLine.invoke(processor, null, operands);
        }
    }

    private static class TextSetTextMatrix
    implements ContentOperator {
        private TextSetTextMatrix() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            float a = ((PdfNumber)operands.get(0)).floatValue();
            float b = ((PdfNumber)operands.get(1)).floatValue();
            float c = ((PdfNumber)operands.get(2)).floatValue();
            float d = ((PdfNumber)operands.get(3)).floatValue();
            float e = ((PdfNumber)operands.get(4)).floatValue();
            float f = ((PdfNumber)operands.get(5)).floatValue();
            processor.textMatrix = processor.textLineMatrix = new Matrix(a, b, c, d, e, f);
        }
    }

    private static class TextMoveNextLine
    implements ContentOperator {
        private final TextMoveStartNextLine moveStartNextLine;

        public TextMoveNextLine(TextMoveStartNextLine moveStartNextLine) {
            this.moveStartNextLine = moveStartNextLine;
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            ArrayList<PdfNumber> tdoperands = new ArrayList<PdfNumber>(2);
            tdoperands.add(0, new PdfNumber(0));
            tdoperands.add(1, new PdfNumber(-processor.gs().leading));
            this.moveStartNextLine.invoke(processor, null, tdoperands);
        }
    }

    private static class ShowText
    implements ContentOperator {
        private ShowText() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            PdfString string = (PdfString)operands.get(0);
            processor.displayPdfString(string);
        }
    }

    private static class MoveNextLineAndShowText
    implements ContentOperator {
        private final TextMoveNextLine textMoveNextLine;
        private final ShowText showText;

        public MoveNextLineAndShowText(TextMoveNextLine textMoveNextLine, ShowText showText) {
            this.textMoveNextLine = textMoveNextLine;
            this.showText = showText;
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            this.textMoveNextLine.invoke(processor, null, new ArrayList(0));
            this.showText.invoke(processor, null, operands);
        }
    }

    private static class MoveNextLineAndShowTextWithSpacing
    implements ContentOperator {
        private final SetTextWordSpacing setTextWordSpacing;
        private final SetTextCharacterSpacing setTextCharacterSpacing;
        private final MoveNextLineAndShowText moveNextLineAndShowText;

        public MoveNextLineAndShowTextWithSpacing(SetTextWordSpacing setTextWordSpacing, SetTextCharacterSpacing setTextCharacterSpacing, MoveNextLineAndShowText moveNextLineAndShowText) {
            this.setTextWordSpacing = setTextWordSpacing;
            this.setTextCharacterSpacing = setTextCharacterSpacing;
            this.moveNextLineAndShowText = moveNextLineAndShowText;
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            PdfNumber aw = (PdfNumber)operands.get(0);
            PdfNumber ac = (PdfNumber)operands.get(1);
            PdfString string = (PdfString)operands.get(2);
            ArrayList<PdfNumber> twOperands = new ArrayList<PdfNumber>(1);
            twOperands.add(0, aw);
            this.setTextWordSpacing.invoke(processor, null, twOperands);
            ArrayList<PdfNumber> tcOperands = new ArrayList<PdfNumber>(1);
            tcOperands.add(0, ac);
            this.setTextCharacterSpacing.invoke(processor, null, tcOperands);
            ArrayList<PdfString> tickOperands = new ArrayList<PdfString>(1);
            tickOperands.add(0, string);
            this.moveNextLineAndShowText.invoke(processor, null, tickOperands);
        }
    }

    private static class ShowTextArray
    implements ContentOperator {
        private ShowTextArray() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList operands) {
            PdfArray array = (PdfArray)operands.get(0);
            float tj = 0.0f;
            ListIterator i = array.listIterator();
            while (i.hasNext()) {
                Object entryObj = i.next();
                if (entryObj instanceof PdfString) {
                    processor.displayPdfString((PdfString)entryObj);
                    tj = 0.0f;
                    continue;
                }
                tj = ((PdfNumber)entryObj).floatValue();
                processor.applyTextAdjust(tj);
            }
        }
    }
}

