/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.parser;

import com.itextpdf.text.pdf.PRIndirectReference;
import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.RandomAccessFileOrArray;
import com.itextpdf.text.pdf.parser.PdfContentStreamProcessor;
import com.itextpdf.text.pdf.parser.SimpleTextExtractingPdfContentRenderListener;
import com.itextpdf.text.pdf.parser.TextProvidingRenderListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ListIterator;

public class PdfTextExtractor {
    private final PdfReader reader;
    private final TextProvidingRenderListener renderListener;

    public PdfTextExtractor(PdfReader reader) {
        this(reader, new SimpleTextExtractingPdfContentRenderListener());
    }

    public PdfTextExtractor(PdfReader reader, TextProvidingRenderListener renderListener) {
        this.reader = reader;
        this.renderListener = renderListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getContentBytesForPage(int pageNum) throws IOException {
        try (RandomAccessFileOrArray f = this.reader.getSafeFile();){
            byte[] contentBytes;
            PdfDictionary pageDictionary = this.reader.getPageN(pageNum);
            PdfObject contentObject = pageDictionary.get(PdfName.CONTENTS);
            byte[] byArray = contentBytes = this.getContentBytesFromContentObject(contentObject);
            return byArray;
        }
    }

    private byte[] getContentBytesFromContentObject(PdfObject contentObject) throws IOException {
        byte[] result;
        switch (contentObject.type()) {
            case 10: {
                PRIndirectReference ref = (PRIndirectReference)contentObject;
                PdfObject directObject = PdfReader.getPdfObject(ref);
                result = this.getContentBytesFromContentObject(directObject);
                break;
            }
            case 7: {
                PRStream stream = (PRStream)PdfReader.getPdfObject(contentObject);
                result = PdfReader.getStreamBytes(stream);
                break;
            }
            case 5: {
                ByteArrayOutputStream allBytes = new ByteArrayOutputStream();
                PdfArray contentArray = (PdfArray)contentObject;
                ListIterator iter = contentArray.listIterator();
                while (iter.hasNext()) {
                    PdfObject element = (PdfObject)iter.next();
                    allBytes.write(this.getContentBytesFromContentObject(element));
                }
                result = allBytes.toByteArray();
                break;
            }
            default: {
                String msg = "Unable to handle Content of type " + contentObject.getClass();
                throw new IllegalStateException(msg);
            }
        }
        return result;
    }

    public String getTextFromPage(int page) throws IOException {
        PdfDictionary pageDic = this.reader.getPageN(page);
        PdfDictionary resourcesDic = pageDic.getAsDict(PdfName.RESOURCES);
        this.renderListener.reset();
        PdfContentStreamProcessor processor = new PdfContentStreamProcessor(this.renderListener);
        processor.processContent(this.getContentBytesForPage(page), resourcesDic);
        return this.renderListener.getResultantText();
    }
}

