/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.parser;

import com.itextpdf.text.pdf.CMapAwareDocumentFont;
import com.itextpdf.text.pdf.DocumentFont;
import com.itextpdf.text.pdf.parser.GraphicsState;
import com.itextpdf.text.pdf.parser.Matrix;
import com.itextpdf.text.pdf.parser.Vector;

public class TextRenderInfo {
    private final String text;
    private final Matrix textToUserSpaceTransformMatrix;
    private final GraphicsState gs;

    TextRenderInfo(String text, GraphicsState gs, Matrix textMatrix) {
        this.text = text;
        this.textToUserSpaceTransformMatrix = textMatrix.multiply(gs.ctm);
        this.gs = gs;
    }

    public String getText() {
        return this.text;
    }

    public float getUnscaledWidth() {
        return this.getStringWidth(this.text);
    }

    public Vector getStartPoint() {
        return new Vector(0.0f, 0.0f, 1.0f).cross(this.textToUserSpaceTransformMatrix);
    }

    public Vector getEndPoint() {
        return new Vector(this.getUnscaledWidth(), 0.0f, 1.0f).cross(this.textToUserSpaceTransformMatrix);
    }

    public float getSingleSpaceWidth() {
        return new Vector(this.getUnscaledFontSpaceWidth(), 0.0f, 1.0f).cross(this.textToUserSpaceTransformMatrix).subtract(this.getStartPoint()).length();
    }

    private float getUnscaledFontSpaceWidth() {
        char charToUse = ' ';
        if (this.gs.font.getWidth(charToUse) == 0) {
            charToUse = '\u00a0';
        }
        return this.getStringWidth(String.valueOf(charToUse));
    }

    private float getStringWidth(String string) {
        CMapAwareDocumentFont font = this.gs.font;
        char[] chars = string.toCharArray();
        float totalWidth = 0.0f;
        for (int i = 0; i < chars.length; ++i) {
            float w = (float)((DocumentFont)font).getWidth(chars[i]) / 1000.0f;
            float wordSpacing = chars[i] == ' ' ? this.gs.wordSpacing : 0.0f;
            totalWidth += (w * this.gs.fontSize + this.gs.characterSpacing + wordSpacing) * this.gs.horizontalScaling;
        }
        return totalWidth;
    }
}

