/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tools;

import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.PdfCopy;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.SimpleBookmark;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class ConcatPdf {
    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("arguments: file1 [file2 ...] destfile");
        } else {
            try {
                int pageOffset = 0;
                ArrayList master = new ArrayList();
                String outFile = args[args.length - 1];
                Document document = null;
                PdfWriter writer = null;
                for (int f = 0; f < args.length - 1; ++f) {
                    PdfReader reader = new PdfReader(args[f]);
                    reader.consolidateNamedDestinations();
                    int n = reader.getNumberOfPages();
                    List bookmarks = SimpleBookmark.getBookmark(reader);
                    if (bookmarks != null) {
                        if (pageOffset != 0) {
                            SimpleBookmark.shiftPageNumbers(bookmarks, pageOffset, null);
                        }
                        master.addAll(bookmarks);
                    }
                    pageOffset += n;
                    System.out.println("There are " + n + " pages in " + args[f]);
                    if (f == 0) {
                        document = new Document(reader.getPageSizeWithRotation(1));
                        writer = new PdfCopy(document, (OutputStream)new FileOutputStream(outFile));
                        document.open();
                    }
                    int i = 0;
                    while (i < n) {
                        PdfImportedPage page = ((PdfCopy)writer).getImportedPage(reader, ++i);
                        ((PdfCopy)writer).addPage(page);
                        System.out.println("Processed page " + i);
                    }
                    ((PdfCopy)writer).freeReader(reader);
                }
                if (!master.isEmpty()) {
                    writer.setOutlines(master);
                }
                document.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

