/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.support.combat.jfx;

import de.rpgframework.support.combat.Combatant;
import de.rpgframework.support.combat.jfx.Token;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.SkinBase;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Circle;
import javafx.scene.text.Text;

class TokenSkin<C extends Combatant>
extends SkinBase<Token<C>> {
    private Token<C> model;
    private Canvas canvas;
    private ImageView image;
    private Text text;
    private GraphicsContext gc;

    protected TokenSkin(Token<C> model) {
        super(model);
        this.model = model;
        this.initComponents();
        this.initLayout();
        this.initInteractivity();
        this.imageRadiusChanged(32);
        model.imageRadiusProperty().addListener((ov, o, n) -> this.imageRadiusChanged((Integer)n));
        model.imageRadiusProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                System.out.println("TokenSkin: invalidated " + observable);
            }
        });
        this.refreshCanvas();
    }

    private void initComponents() {
        this.image = new ImageView(this.model.getImage());
        this.image.setPreserveRatio(false);
        this.canvas = new Canvas(80.0, 80.0);
        this.text = new Text(this.model.getText());
        this.text.setStyle("-fx-font-size: 125%; -fx-fill: white; -fx-effect: dropshadow(three-pass-box, rgba(0,0,0,0.8), 2, 1, 1, 1);");
        this.gc = this.canvas.getGraphicsContext2D();
    }

    private void initLayout() {
        this.model.impl_getChildren().addAll((Object[])new Node[]{this.canvas, this.image, this.text});
    }

    private void initInteractivity() {
        this.model.rightValueMaxProperty().addListener((ov, o, n) -> this.refreshCanvas());
        this.model.rightValueProperty().addListener((ov, o, n) -> this.refreshCanvas());
        this.model.leftValueMaxProperty().addListener((ov, o, n) -> this.refreshCanvas());
        this.model.leftValueProperty().addListener((ov, o, n) -> this.refreshCanvas());
    }

    private void refreshCanvas() {
        double from;
        int i;
        this.gc.clearRect(0.0, 0.0, this.canvas.getWidth(), this.canvas.getHeight());
        double perSegment = 180.0 / (double)this.model.rightValueMaxProperty().get();
        double spacing = 1.5;
        double realPS = perSegment - 2.0 * spacing;
        this.gc.setFill((Paint)Color.GREEN);
        for (i = 0; i < this.model.getRightValueMax(); ++i) {
            from = 270.0 - spacing + (double)i * perSegment;
            if (i < this.model.getRightValue()) {
                this.gc.fillArc(0.0, 0.0, 80.0, 80.0, from, realPS, ArcType.ROUND);
                continue;
            }
            this.gc.strokeArc(0.0, 0.0, 80.0, 80.0, from, realPS, ArcType.ROUND);
        }
        perSegment = 180.0 / (double)this.model.leftValueMaxProperty().get();
        spacing = 1.5;
        realPS = perSegment - 2.0 * spacing;
        this.gc.setFill((Paint)Color.RED);
        for (i = 0; i < this.model.leftValueProperty().get(); ++i) {
            from = 270.0 - spacing - (double)i * perSegment;
            this.gc.fillArc(0.0, 0.0, 80.0, 80.0, from - realPS, realPS, ArcType.ROUND);
        }
    }

    private void imageRadiusChanged(int newRadius) {
        this.image.setFitWidth((double)(newRadius * 2));
        this.image.setFitHeight((double)(newRadius * 2));
        this.image.setClip((Node)new Circle((double)newRadius, (double)newRadius, (double)newRadius));
    }
}

