/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.addressbook;

import de.rpgframework.addressbook.IdentityInformation;
import de.rpgframework.addressbook.InfoType;
import de.rpgframework.addressbook.Parameter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DefaultIdentityInformation
implements IdentityInformation {
    private InfoType type;
    protected String value;
    private Map<Parameter, String> parameter;

    public DefaultIdentityInformation(InfoType type, String value) {
        this.type = type;
        this.value = value;
        this.parameter = new HashMap<Parameter, String>();
    }

    public DefaultIdentityInformation(InfoType type, String value, Map.Entry<Parameter, String> ... entries) {
        this.type = type;
        this.value = value;
        this.parameter = new HashMap<Parameter, String>();
        for (Map.Entry<Parameter, String> entry : entries) {
            this.parameter.put(entry.getKey(), entry.getValue());
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.type + "=" + this.value);
        if (!this.parameter.isEmpty()) {
            buf.append("(");
            Iterator<Parameter> it = this.parameter.keySet().iterator();
            while (it.hasNext()) {
                Parameter p = it.next();
                buf.append(p + "=" + this.parameter.get((Object)p));
                if (!it.hasNext()) continue;
                buf.append(",");
            }
            buf.append(")");
        }
        return buf.toString();
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public InfoType getType() {
        return this.type;
    }

    @Override
    public String getParameter(Parameter param) {
        return this.parameter.get((Object)param);
    }

    @Override
    public void setParameter(Parameter param, String value) {
        this.parameter.put(param, value);
    }

    @Override
    public Set<Map.Entry<Parameter, String>> getParameters() {
        return this.parameter.entrySet();
    }
}

