/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.boot;

import de.rpgframework.ConfigOption;
import de.rpgframework.RPGFramework;
import de.rpgframework.RPGFrameworkInitCallback;
import de.rpgframework.RPGFrameworkPlugin;
import de.rpgframework.boot.BootStep;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoadFrameworkPluginsBootStep
implements BootStep {
    private static final Logger logger = Logger.getLogger("rpgframework");
    private RPGFramework framework;

    public LoadFrameworkPluginsBootStep(RPGFramework instance) {
        this.framework = instance;
    }

    @Override
    public String getID() {
        return "FRAMEWORK_PLUGINS";
    }

    @Override
    public int getWeight() {
        return 20;
    }

    @Override
    public boolean shallBeDisplayedToUser() {
        return false;
    }

    @Override
    public List<ConfigOption<?>> getConfiguration() {
        return null;
    }

    @Override
    public boolean execute(RPGFrameworkInitCallback callback) {
        if (callback != null) {
            callback.message("Load framework plugins");
        }
        ArrayList<RPGFrameworkPlugin> frameworkPlugins = new ArrayList<RPGFrameworkPlugin>();
        Iterator<RPGFrameworkPlugin> it = ServiceLoader.load(RPGFrameworkPlugin.class, RPGFramework.class.getClassLoader()).iterator();
        while (it.hasNext()) {
            try {
                RPGFrameworkPlugin plugin = it.next();
                logger.info("Found framework plugin " + plugin.getClass());
                frameworkPlugins.add(plugin);
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "Error instantiating plugin", e);
                e.printStackTrace();
            }
        }
        logger.fine("Sort plugins");
        Collections.sort(frameworkPlugins, new Comparator<RPGFrameworkPlugin>(){

            @Override
            public int compare(RPGFrameworkPlugin o1, RPGFrameworkPlugin o2) {
                return o1.getClass().getName().compareTo(o2.getClass().getName());
            }
        });
        for (RPGFrameworkPlugin plugin : frameworkPlugins) {
            logger.fine("Initialize " + plugin.getClass() + " // " + plugin.getClass().getPackage().getImplementationTitle());
            try {
                if (callback != null) {
                    callback.message("Initialize " + plugin.getClass().getSimpleName());
                }
                plugin.initialize(this.framework);
            }
            catch (Throwable e) {
                System.err.println("Error loading plugin: " + e);
                logger.log(Level.SEVERE, "Error loading plugin", e);
            }
        }
        return true;
    }
}

