/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.core;

import de.rpgframework.core.CommandBusListener;
import de.rpgframework.core.CommandResult;
import de.rpgframework.core.CommandType;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class CommandBus {
    private static List<CommandBusListener> listener = new ArrayList<CommandBusListener>();

    public static void registerBusCommandListener(CommandBusListener callback) {
        if (!listener.contains(callback)) {
            listener.add(callback);
        }
    }

    public static void unregisterBusCommandListener(CommandBusListener callback) {
        listener.remove(callback);
    }

    public static boolean canProcessCommand(Object src, CommandType type, Object ... param) {
        for (CommandBusListener callback : listener) {
            try {
                if (!callback.willProcessCommand(src, type, param)) continue;
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                StringWriter err = new StringWriter();
                e.printStackTrace(new PrintWriter(err));
                return false;
            }
        }
        return false;
    }

    public static List<String> findCommandProcessors(Object src, CommandType type, Object ... param) {
        ArrayList<String> ret = new ArrayList<String>();
        for (CommandBusListener callback : listener) {
            try {
                if (!callback.willProcessCommand(src, type, param)) continue;
                ret.add(callback.getReadableName());
            }
            catch (Exception e) {
                e.printStackTrace();
                StringWriter err = new StringWriter();
                e.printStackTrace(new PrintWriter(err));
            }
        }
        return ret;
    }

    public static CommandResult fireCommand(Object src, CommandType type, Object ... param) {
        for (CommandBusListener callback : listener) {
            try {
                if (!callback.willProcessCommand(src, type, param)) continue;
                return callback.handleCommand(src, type, param);
            }
            catch (Exception e) {
                e.printStackTrace();
                StringWriter err = new StringWriter();
                e.printStackTrace(new PrintWriter(err));
                return new CommandResult(type, false, err.toString());
            }
        }
        return new CommandResult(type, false, "No responsible plugin found", false);
    }

    public static CommandResult fireCommand(String pluginID, Object src, CommandType type, Object ... param) {
        for (CommandBusListener callback : listener) {
            if (!callback.getReadableName().equals(pluginID)) continue;
            try {
                if (callback.willProcessCommand(src, type, param)) {
                    System.out.println("##########" + callback + " will process " + type);
                    return callback.handleCommand(src, type, param);
                }
                System.out.println(callback + " wont process " + type);
            }
            catch (Exception e) {
                e.printStackTrace();
                StringWriter err = new StringWriter();
                e.printStackTrace(new PrintWriter(err));
                return new CommandResult(type, false, err.toString());
            }
        }
        return new CommandResult(type, false, "No responsible plugin found", false);
    }
}

