/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.media;

import de.rpgframework.media.MediaTag;
import de.rpgframework.media.TagAge;
import de.rpgframework.media.TagGender;
import de.rpgframework.media.TagLandscape;
import de.rpgframework.media.TagLifeform;
import de.rpgframework.media.TagMood;
import de.rpgframework.media.TagPlaces;
import de.rpgframework.media.TagTempo;
import de.rpgframework.media.TagWildness;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TagRegistry {
    private static List<Class<? extends MediaTag>> taxonomy = new ArrayList<Class<? extends MediaTag>>();

    public static void register(Class<? extends MediaTag> cls) {
        if (!cls.isEnum()) {
            throw new IllegalArgumentException("Can only register enums of MediaTag");
        }
        if (!taxonomy.contains(cls)) {
            taxonomy.add(cls);
        }
    }

    public static Collection<Class<? extends MediaTag>> getKnownTagTypes() {
        return taxonomy;
    }

    public static String getTagTypeID(MediaTag tag) {
        return tag.getClass().getSimpleName();
    }

    public static MediaTag resolveTag(String simpleClsName, String value) {
        for (Class<? extends MediaTag> cls : taxonomy) {
            if (!cls.getSimpleName().equals(simpleClsName)) continue;
            try {
                return (MediaTag)cls.getMethod("valueOf", String.class).invoke(null, value);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    static {
        TagRegistry.register(TagAge.class);
        TagRegistry.register(TagGender.class);
        TagRegistry.register(TagLandscape.class);
        TagRegistry.register(TagLifeform.class);
        TagRegistry.register(TagMood.class);
        TagRegistry.register(TagPlaces.class);
        TagRegistry.register(TagTempo.class);
        TagRegistry.register(TagWildness.class);
    }
}

