/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.crypto;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CryptoDecoder {
    private static final System.Logger logger = System.getLogger(CryptoDecoder.class.getPackageName());
    private static final String PUBKEY = "-----BEGIN PGP MESSAGE-----\nVersion: BCPG v1.51\n\nMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQC4TxJp1lJNR7R56s8DzwLOAu7b\nmOayZaZgTrQDemaDbimgXX74Eho+WR6h84Tiw4aJgsa5FEaFPjHPYo0+PsieHDB3\nLA/pBdLiahvO+3oI9vFWlDlTXywmNqRTcNDjmtH+gHGqIj/BJ5WQ/zgxubxNL6qZ\n15/VOgrNJth632PKNQIDAQAB\n=Iuo2\n-----END PGP MESSAGE-----";
    private static Cipher rsa;
    private static PublicKey publicKey;

    private static PublicKey readKey() throws IOException {
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(PUBKEY.getBytes());
            ArmoredInputStream in = new ArmoredInputStream((InputStream)bin);
            byte[] encodedPublicKey = new byte[in.available()];
            in.read(encodedPublicKey);
            in.close();
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(encodedPublicKey);
            return keyFactory.generatePublic(publicKeySpec);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static String decode(String licenseString) {
        byte[] encoded = Base64.getDecoder().decode(licenseString.getBytes());
        try {
            rsa.init(2, publicKey);
            byte[] decoded = rsa.doFinal(encoded);
            return new String(decoded, StandardCharsets.UTF_8);
        }
        catch (StringIndexOutOfBoundsException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            throw new IllegalArgumentException("Invalid license.", e);
        }
    }

    static {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            rsa = Cipher.getInstance("RSA", "BC");
            publicKey = CryptoDecoder.readKey();
        }
        catch (IOException e) {
            logger.log(System.Logger.Level.ERROR, "Could not decode public key for licenses", (Throwable)e);
        }
        catch (Throwable e) {
            logger.log(System.Logger.Level.ERROR, "Could not initialize crypto framework - license management not working", e);
        }
    }
}

