package de.rpgframework.random;

import de.rpgframework.classification.Classification;
import de.rpgframework.classification.ClassificationType;
import de.rpgframework.classification.GenericClassificationType;

public enum ActorRole implements Classification<ActorRole> {
	
	/*
	 * The entity asking the party to work for him 
	 */
	CLIENT,
	/*
	 * An armed opponent to make the run more interesting
	 */
	GRUNT,
	/*
	 * The entity to be acquired, transported, killed, protected ...
	 */
	TARGET,
	UNDEFINED
	;

	//-------------------------------------------------------------------
	/**
	 * @see de.rpgframework.classification.Classification#getType()
	 */
	@Override
	public ClassificationType getType() {
		return GenericClassificationType.ROLE;
	}

	//-------------------------------------------------------------------
	/**
	 * @see de.rpgframework.classification.Classification#getValue()
	 */
	@Override
	public ActorRole getValue() {
		return this;
	}
	
}