package de.rpgframework.random;

import java.lang.System.Logger;
import java.lang.System.Logger.Level;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;

import de.rpgframework.classification.Classification;
import de.rpgframework.classification.ClassificationType;
import de.rpgframework.classification.Gender;
import de.rpgframework.classification.GenericClassificationType;

/**
 * @author prelle
 *
 */
public class NSCGenerator implements RandomGenerator {

	private final static Logger logger = System.getLogger("rpgframework.random");

	public final static Random RANDOM = new Random();

	//-------------------------------------------------------------------
	public NSCGenerator() {
	}

	//-------------------------------------------------------------------
	/**
	 * @see de.rpgframework.random.RandomGenerator#getType()
	 */
	@Override
	public GeneratorType getType() {
		return GeneratorType.NSC;
	}

	//-------------------------------------------------------------------
	/**
	 * @see de.rpgframework.random.RandomGenerator#matchesFilter(de.rpgframework.classification.Classification)
	 */
	@Override
	public boolean matchesFilter(Classification<?> filter) {
		// TODO Auto-generated method stub
		return false;
	}

	//-------------------------------------------------------------------
	/**
	 * @see de.rpgframework.random.RandomGenerator#understandsHint(de.rpgframework.classification.Classification)
	 */
	@Override
	public boolean understandsHint(Classification<?> filter) {
		if (filter==GenericClassificationType.ROLE) return true;
		return false;
	}

	//-------------------------------------------------------------------
	protected Classification<?> getHint(ClassificationType needle, Classification<?>...haystack) {
		for (Classification<?> tmp : haystack) {
			if (tmp.getType()==needle)
				return tmp;
		}
		return null;

	}

	//-------------------------------------------------------------------
	/**
	 * @see de.rpgframework.random.RandomGenerator#generate(de.rpgframework.classification.Classification[])
	 */
	@Override
	public Object generate(Map<GeneratorVariable,Integer> variables, Classification<?>... classifier) {
		logger.log(Level.INFO, "ENTER: createNSC("+Arrays.toString(classifier)+")");
		/*
		 * Roll gender
		 */
		Gender gender = RANDOM.nextBoolean()?Gender.MALE:Gender.FEMALE;

		/*
		 * Copy hints
		 */
		@SuppressWarnings({ "rawtypes", "unchecked" })
		List<Classification<?>> hints = new ArrayList(List.of(classifier));
		hints.add(0, gender);

		/*
		 * Roll a name
		 */
		String name = (String) RandomGeneratorRegistry.generate(GeneratorType.NAME_PERSON, List.of(), hints, variables);

		/*
		 * Determine roll or take it from hints
		 */
		ActorRole role = ActorRole.UNDEFINED;
		if (RandomGenerator.contains(hints, GenericClassificationType.ROLE)) {
			role = RandomGenerator.getValueOf(hints, GenericClassificationType.ROLE);
		}

		// Create an actor
		Actor actor = new Actor(role, name);
		actor.setGender(gender);
		for (Classification<?> cls : classifier) {
			if (cls.getType().isRuleSpecific()) {
				actor.setHint(cls);
//				if (cls.getValue() instanceof Enum) {
//					logger.log(Level.WARNING, "as enum: "+ ((Enum)cls.getValue()).name());
//					actor.setGenericVariable(cls.getType().getId(), ((Enum)cls.getValue()).name());
//				} else {
//					logger.log(Level.WARNING, "as String: "+ cls.getValue().toString());
//					actor.setGenericVariable(cls.getType().getId(), cls.getValue().toString());
//				}
			}
		}

		logger.log(Level.INFO, "LEAVE createNSC()="+actor);
		return actor;
	}

	//-------------------------------------------------------------------
	/**
	 * @see de.rpgframework.random.RandomGenerator#getRequiredVariables()
	 */
	@Override
	public Collection<ClassificationType> getRequiredVariables() {
		return List.of();
	}

}
