/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.random;

import de.rpgframework.classification.Classification;
import de.rpgframework.classification.ClassificationType;
import de.rpgframework.classification.Gender;
import de.rpgframework.classification.GenericClassificationType;
import de.rpgframework.random.Actor;
import de.rpgframework.random.ActorRole;
import de.rpgframework.random.GeneratorType;
import de.rpgframework.random.GeneratorVariable;
import de.rpgframework.random.RandomGenerator;
import de.rpgframework.random.RandomGeneratorRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class NSCGenerator
implements RandomGenerator {
    private static final System.Logger logger = System.getLogger("rpgframework.random");
    public static final Random RANDOM = new Random();

    @Override
    public GeneratorType getType() {
        return GeneratorType.NSC;
    }

    @Override
    public boolean matchesFilter(Classification<?> filter) {
        return false;
    }

    @Override
    public boolean understandsHint(Classification<?> filter) {
        return filter == GenericClassificationType.ROLE;
    }

    protected Classification<?> getHint(ClassificationType needle, Classification<?> ... haystack) {
        for (Classification<?> tmp : haystack) {
            if (tmp.getType() != needle) continue;
            return tmp;
        }
        return null;
    }

    @Override
    public Object generate(Map<GeneratorVariable, Integer> variables, Classification<?> ... classifier) {
        logger.log(System.Logger.Level.INFO, "ENTER: createNSC(" + Arrays.toString(classifier) + ")");
        Gender gender = RANDOM.nextBoolean() ? Gender.MALE : Gender.FEMALE;
        ArrayList hints = new ArrayList(List.of(classifier));
        hints.add(0, (Classification<?>)gender);
        String name = (String)RandomGeneratorRegistry.generate(GeneratorType.NAME_PERSON, List.of(), hints, variables);
        ActorRole role = ActorRole.UNDEFINED;
        if (RandomGenerator.contains(hints, GenericClassificationType.ROLE)) {
            role = (ActorRole)((Object)RandomGenerator.getValueOf(hints, GenericClassificationType.ROLE));
        }
        Actor actor = new Actor(role, name);
        actor.setGender(gender);
        for (Classification<?> cls : classifier) {
            if (!cls.getType().isRuleSpecific()) continue;
            actor.setHint(cls);
        }
        logger.log(System.Logger.Level.INFO, "LEAVE createNSC()=" + String.valueOf(actor));
        return actor;
    }

    @Override
    public Collection<ClassificationType> getRequiredVariables() {
        return List.of();
    }
}

