/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.random;

import de.rpgframework.MultiLanguageResourceBundle;
import de.rpgframework.classification.Classification;
import de.rpgframework.classification.Gender;
import de.rpgframework.classification.Genre;
import de.rpgframework.classification.TagAge;
import de.rpgframework.genericrpg.modification.Modification;
import de.rpgframework.genericrpg.modification.ValueModification;
import de.rpgframework.random.Actor;
import de.rpgframework.random.ActorRole;
import de.rpgframework.random.AddActorInstruction;
import de.rpgframework.random.GeneratorType;
import de.rpgframework.random.GeneratorVariable;
import de.rpgframework.random.PlotNode;
import de.rpgframework.random.RandomGeneratorRegistry;
import de.rpgframework.random.RollResult;
import de.rpgframework.random.RollTable;
import de.rpgframework.random.RollTableList;
import de.rpgframework.random.TextLine;
import de.rpgframework.random.VariableHolderNode;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import org.prelle.simplepersist.Persister;

public abstract class RollTableGenerator {
    private static final System.Logger logger = System.getLogger("rpgframework.random");
    protected static Persister serializer;
    protected static Random random;
    protected Map<String, RollTable> tables;
    protected MultiLanguageResourceBundle res;

    public RollTableGenerator(MultiLanguageResourceBundle res) {
        this.res = res;
        this.tables = new HashMap<String, RollTable>();
    }

    protected void loadTables(InputStream stream) {
        try {
            RollTableList loaded = (RollTableList)serializer.read(RollTableList.class, stream);
            logger.log(System.Logger.Level.INFO, "Loaded " + loaded.size() + " tables");
            for (RollTable tmp : loaded) {
                this.tables.put(tmp.id, tmp);
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Failed loading roll tables", (Throwable)e);
        }
    }

    protected abstract GeneratorVariable resolveModifier(String var1);

    protected List<Classification<?>> parseVariables(String line) {
        ArrayList ret = new ArrayList();
        StringTokenizer tok = new StringTokenizer(line, ",; ");
        while (tok.hasMoreTokens()) {
            String keyValue = tok.nextToken();
            String[] pair = keyValue.split(":");
            switch (pair[0]) {
                case "AGE": {
                    ret.add((Classification<?>)TagAge.valueOf((String)pair[1]));
                    break;
                }
                case "GENDER": {
                    ret.add((Classification<?>)Gender.valueOf((String)pair[1]));
                    break;
                }
                case "GENRE": {
                    ret.add((Classification<?>)Genre.valueOf((String)pair[1]));
                    break;
                }
                case "ROLE": {
                    ret.add(ActorRole.valueOf(pair[1]));
                }
            }
        }
        return ret;
    }

    protected List<GeneratorVariable> parseModifier(String line) {
        ArrayList<GeneratorVariable> ret = new ArrayList<GeneratorVariable>();
        StringTokenizer tok = new StringTokenizer(line, ",; ");
        while (tok.hasMoreTokens()) {
            String keyValue = tok.nextToken();
            String[] pair = keyValue.split(":");
            try {
                GeneratorVariable var = this.resolveModifier(pair[0]);
                logger.log(System.Logger.Level.INFO, "-----------> " + String.valueOf(var) + " = " + pair[1]);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return ret;
    }

    public static int rollD6(int amount) {
        int sum = 0;
        for (int i = 0; i < amount; ++i) {
            sum += random.nextInt(6) + 1;
        }
        return sum;
    }

    public static int rollD20(int amount) {
        int sum = 0;
        for (int i = 0; i < amount; ++i) {
            sum += random.nextInt(20) + 1;
        }
        return sum;
    }

    public static int rollD100(int amount) {
        int sum = 0;
        for (int i = 0; i < amount; ++i) {
            sum += random.nextInt(100) + 1;
        }
        return sum;
    }

    public void roll(RollTable table, PlotNode node, Locale loc) {
        if (table.getAddNode() != null) {
            String i18nKey = table.id + "." + table.getAddNode().getTitle();
            PlotNode pn = new PlotNode(table.getAddNode().getType());
            logger.log(System.Logger.Level.DEBUG, "When creating PlotNode I have hints " + String.valueOf(node.getHints()));
            pn.copyHints(node);
            pn.setI18n(i18nKey);
            if (node.getParent() != null) {
                node.getParent().addNode(pn);
            } else {
                node.addNode(pn);
            }
            node = pn;
        }
        TextLine line = new TextLine();
        node.addLine(line);
        Object intro = "";
        String introKey = table.id + ".intro";
        if (this.res.getString(introKey, loc) != introKey) {
            intro = this.res.getString(introKey, loc) + " ";
            line.addText(introKey);
        }
        int d6 = table.d6;
        int value = RollTableGenerator.rollD6(d6);
        for (String modName : table.getModifierNames()) {
            GeneratorVariable mod = this.resolveModifier(modName);
            if (mod == null) continue;
            int modVal = node.getVariable(mod);
            logger.log(System.Logger.Level.DEBUG, "Modify result by " + modName + "=" + modVal);
            value += modVal;
        }
        RollResult result = table.getResultFor(value);
        if (result == null) {
            logger.log(System.Logger.Level.ERROR, "Failed on table " + table.id);
            return;
        }
        String i18nKey = table.id + "." + result.getId();
        logger.log(System.Logger.Level.INFO, (String)intro + this.res.getString(i18nKey, loc));
        line.addText(i18nKey);
        for (Modification mod : result.getModifications()) {
            ValueModification vMod;
            if (!(mod instanceof ValueModification) || !"VARIABLE".equals((vMod = (ValueModification)mod).getReferenceType())) continue;
            logger.log(System.Logger.Level.ERROR, "TODO: " + String.valueOf(vMod));
        }
        VariableHolderNode subNode = node;
        if (result.getAddActor() != null) {
            AddActorInstruction instr = result.getAddActor();
            logger.log(System.Logger.Level.INFO, "All hints so far: " + String.valueOf(node.getHints()));
            ArrayList hints = new ArrayList(List.of(instr.getRole()));
            hints.addAll(node.getHints());
            if (instr.getVariables() != null && !instr.getVariables().isBlank()) {
                hints.addAll(this.parseVariables(instr.getVariables()));
            }
            Actor actor = (Actor)RandomGeneratorRegistry.generate(GeneratorType.NSC, List.of(), hints, node.getVariables());
            logger.log(System.Logger.Level.DEBUG, "Actor = " + String.valueOf(actor));
            node.addActor(actor);
            subNode = actor;
        }
        for (RollTable sub : result.getSubtables()) {
            logger.log(System.Logger.Level.DEBUG, "Execute subtable " + sub.id);
            this.rollSubtable(sub, subNode, loc, line, i18nKey);
        }
        String nextTable = table.nextTable;
        if (result.getNextTable() != null) {
            nextTable = result.getNextTable();
        }
        if (nextTable == null) {
            logger.log(System.Logger.Level.DEBUG, "No next table - stop after " + table.id);
            return;
        }
        RollTable next = this.tables.get(nextTable);
        if (next == null) {
            logger.log(System.Logger.Level.ERROR, "After table '" + table.id + "' the next table '" + nextTable + "' cannot be found");
            return;
        }
        this.roll(next, node, loc);
    }

    public void simpleRoll(RollTable table, VariableHolderNode node, Locale loc) {
        int count = table.draw > 0 ? table.draw : 1;
        RollResult result = null;
        for (int i = 0; i < count; ++i) {
            int value = 0;
            if (table.d6 > 0) {
                value += RollTableGenerator.rollD6(table.d6);
            }
            if (table.d20 > 0) {
                value += RollTableGenerator.rollD20(table.d20);
            }
            if (table.d00 > 0) {
                value += RollTableGenerator.rollD100(table.d00);
            }
            for (String modName : table.getModifierNames()) {
                GeneratorVariable mod = this.resolveModifier(modName);
                if (mod == null) continue;
                int modVal = node.getVariable(mod);
                logger.log(System.Logger.Level.DEBUG, "Modify result by " + modName + "=" + modVal);
                value += modVal;
            }
            result = table.getResultFor(value);
            if (result == null) {
                logger.log(System.Logger.Level.ERROR, "Failed on table {0} - no result for {1}", table.id, value);
                return;
            }
            logger.log(System.Logger.Level.INFO, "Roll {0} resulted in {1}", new Object[]{value, result});
            String i18nKey = result.getId();
            String varName = table.id.toUpperCase(loc);
            GeneratorVariable variable = this.resolveModifier(varName);
            node.setVariable(variable, i18nKey);
        }
        String nextTable = table.nextTable;
        if (result.getNextTable() != null) {
            nextTable = result.getNextTable();
        }
        if (nextTable == null) {
            logger.log(System.Logger.Level.DEBUG, "No next table - stop after " + table.id);
            return;
        }
        RollTable next = this.tables.get(nextTable);
        if (next == null) {
            logger.log(System.Logger.Level.ERROR, "After table '" + table.id + "' the next table '" + nextTable + "' cannot be found");
            return;
        }
        this.simpleRoll(next, node, loc);
    }

    private void rollSubtable(RollTable table, VariableHolderNode node, Locale loc, TextLine line, String prefix) {
        int d6 = table.d6;
        int value = RollTableGenerator.rollD6(d6);
        RollResult result = table.getResultFor(value);
        if (result == null) {
            logger.log(System.Logger.Level.ERROR, "Failed on table " + table.id);
            return;
        }
        String i18nKey = prefix + "." + table.id + "." + result.getId();
        logger.log(System.Logger.Level.INFO, this.res.getString(i18nKey, loc));
        line.addText(i18nKey);
        for (Modification mod : result.getModifications()) {
            if (!(mod instanceof ValueModification)) continue;
            ValueModification vMod = (ValueModification)mod;
            logger.log(System.Logger.Level.ERROR, "TODO: " + String.valueOf(vMod));
        }
    }

    static {
        random = new Random();
        serializer = new Persister();
    }
}

