/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.random.withoutnumber;

import de.rpgframework.MultiLanguageResourceBundle;
import de.rpgframework.classification.Classification;
import de.rpgframework.classification.ClassificationType;
import de.rpgframework.classification.GenericClassificationType;
import de.rpgframework.classification.Genre;
import de.rpgframework.core.RoleplayingSystem;
import de.rpgframework.genericrpg.data.DataSet;
import de.rpgframework.genericrpg.data.GenericCore;
import de.rpgframework.random.GeneratorType;
import de.rpgframework.random.GeneratorVariable;
import de.rpgframework.random.Plot;
import de.rpgframework.random.RandomGenerator;
import de.rpgframework.random.RollTable;
import de.rpgframework.random.RollTableGenerator;
import de.rpgframework.random.withoutnumber.StoryTag;
import de.rpgframework.random.withoutnumber.StoryTagList;
import de.rpgframework.random.withoutnumber.StoryTagValue;
import de.rpgframework.random.withoutnumber.WithoutNumberVariable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.prelle.simplepersist.Persister;
import org.prelle.simplepersist.SerializationException;

public class StoryTagGenerator
extends RollTableGenerator
implements RandomGenerator {
    private static final System.Logger logger = System.getLogger("rpgframework.withoutnumber");
    private List<Classification<?>> classifications = new ArrayList();
    private GenericCore core;

    public StoryTagGenerator(MultiLanguageResourceBundle RES, String prefix, Genre genre) {
        super(RES);
        this.classifications.add((Classification<?>)genre);
        logger.log(System.Logger.Level.INFO, "START -------------------------------Core-----------------------------------------------");
        DataSet core = new DataSet((Object)this, RoleplayingSystem.ALL, "cwn", "cwn", new Locale[]{Locale.ENGLISH});
        Class<StoryTagGenerator> clazz = StoryTagGenerator.class;
        List list = null;
        try {
            list = GenericCore.loadDataItems(StoryTagList.class, StoryTag.class, (DataSet)core, (InputStream)clazz.getResourceAsStream("cwn_mission_tags.xml"));
            logger.log(System.Logger.Level.DEBUG, "Loaded {0} missions tags", list.size());
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Failed loading missions tags", (Throwable)e);
        }
        String key = prefix + "_tags_table.xml";
        logger.log(System.Logger.Level.INFO, "Try load " + key);
        InputStream ins = this.getClass().getResourceAsStream(key);
        super.loadTables(ins);
    }

    @Override
    public GeneratorType getType() {
        return GeneratorType.RUN;
    }

    @Override
    public Collection<ClassificationType> getRequiredVariables() {
        return List.of(GenericClassificationType.GENRE);
    }

    @Override
    public boolean matchesFilter(Classification<?> filter) {
        for (Classification<?> cls : this.classifications) {
            if (cls.getType() != filter.getType()) continue;
            return cls.getValue() == filter.getValue();
        }
        return false;
    }

    @Override
    public boolean understandsHint(Classification<?> filter) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object generate(Map<GeneratorVariable, Integer> variables, Classification<?> ... classifier) {
        logger.log(System.Logger.Level.INFO, "ENTER: generate(var={0}, class={1})", variables, Arrays.toString(classifier));
        Plot plot = new Plot();
        for (Classification<?> tmp : classifier) {
            plot.setHint(tmp);
        }
        try {
            StoryTagValue tagValue;
            StoryTag tag;
            RollTable table = (RollTable)this.tables.get(WithoutNumberVariable.MISSION_TAG.name());
            logger.log(System.Logger.Level.DEBUG, "Roll with classifier " + String.valueOf(plot.getHints()));
            super.simpleRoll(table, plot, Locale.getDefault());
            List list = (List)plot.getGenericVariable(WithoutNumberVariable.MISSION_TAG);
            List enemyList = (List)plot.getGenericVariable(WithoutNumberVariable.ENEMY);
            if (list.size() > 0) {
                tag = (StoryTag)GenericCore.getItem(StoryTag.class, (String)((String)list.get(0)));
                if (tag == null) {
                    logger.log(System.Logger.Level.ERROR, "Unknown tag {0}", list.get(0));
                }
                tagValue = new StoryTagValue(tag);
                plot.setTag1(tagValue);
                if (!tag.getEnemies().isEmpty()) {
                    tagValue.setEnemy(tag.getEnemies().get(random.nextInt(tag.getEnemies().size())).getId());
                }
                if (!tag.getFriends().isEmpty()) {
                    tagValue.setFriend(tag.getFriends().get(random.nextInt(tag.getFriends().size())).getId());
                }
                if (!tag.getComplications().isEmpty()) {
                    tagValue.setComplication(tag.getComplications().get(random.nextInt(tag.getComplications().size())).getId());
                }
                if (!tag.getThings().isEmpty()) {
                    tagValue.setThing(tag.getThings().get(random.nextInt(tag.getThings().size())).getId());
                }
                if (!tag.getPlaces().isEmpty()) {
                    tagValue.setPlace(tag.getPlaces().get(random.nextInt(tag.getPlaces().size())).getId());
                }
            }
            if (list.size() > 1) {
                tag = (StoryTag)GenericCore.getItem(StoryTag.class, (String)((String)list.get(1)));
                tagValue = new StoryTagValue(tag);
                plot.setTag2(tagValue);
                if (!tag.getEnemies().isEmpty()) {
                    tagValue.setEnemy(tag.getEnemies().get(random.nextInt(tag.getEnemies().size())).getId());
                }
                if (!tag.getFriends().isEmpty()) {
                    tagValue.setFriend(tag.getFriends().get(random.nextInt(tag.getFriends().size())).getId());
                }
                if (!tag.getComplications().isEmpty()) {
                    tagValue.setComplication(tag.getComplications().get(random.nextInt(tag.getComplications().size())).getId());
                }
                if (!tag.getThings().isEmpty()) {
                    tagValue.setThing(tag.getThings().get(random.nextInt(tag.getThings().size())).getId());
                }
                if (!tag.getPlaces().isEmpty()) {
                    tagValue.setPlace(tag.getPlaces().get(random.nextInt(tag.getPlaces().size())).getId());
                }
            }
            try {
                new Persister().write((Object)plot, (OutputStream)System.out);
            }
            catch (SerializationException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Plot plot2 = plot;
            return plot2;
        }
        finally {
            logger.log(System.Logger.Level.DEBUG, "LEAVE: generate");
        }
    }

    @Override
    protected GeneratorVariable resolveModifier(String name) {
        logger.log(System.Logger.Level.TRACE, "resolve {0}", name);
        return WithoutNumberVariable.valueOf(name);
    }
}

